% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_mpd.R
\name{mpd}
\alias{mpd}
\alias{mpd.matrix}
\alias{mpd.cpt_list}
\title{Maximal Prime Decomposition}
\usage{
mpd(x, save_graph = TRUE)

\method{mpd}{matrix}(x, save_graph = TRUE)

\method{mpd}{cpt_list}(x, save_graph = TRUE)
}
\arguments{
\item{x}{Either a neighbor matrix or a \code{cpt_list} object}

\item{save_graph}{Logical indicating if the moralized graph should be kept.
Useful when \code{x} is a \code{cpt_list} object.}
}
\value{
- \code{prime_ints}: a list with the prime components,
- \code{flawed}: indicating which prime components that are triangulated
- \code{jt_collect}: the MPD junction tree prepared for collecting
}
\description{
Find the maximal prime decomposition and its associated junction tree
}
\examples{

library(igraph)
el <- matrix(c(
"A", "T",
"T", "E",
"S", "L",
"S", "B",
"L", "E",
"E", "X",
"E", "D",
"B", "D"),
 nc = 2,
 byrow = TRUE
)

g <- igraph::graph_from_edgelist(el, directed = FALSE)
A <- igraph::as_adjacency_matrix(g, sparse = FALSE)
mpd(A)
}
