% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svyCreateTableOneJS.R
\name{svyCreateTableOneJS}
\alias{svyCreateTableOneJS}
\title{svyCreateTableOneJS: Modified CreateTableOne function in tableone package}
\usage{
svyCreateTableOneJS(
  vars,
  strata = NULL,
  strata2 = NULL,
  data,
  factorVars = NULL,
  includeNA = F,
  test = T,
  showAllLevels = T,
  printToggle = F,
  quote = F,
  smd = F,
  Labels = F,
  nonnormal = NULL,
  catDigits = 1,
  contDigits = 2,
  pDigits = 3,
  labeldata = NULL,
  psub = T,
  minMax = F
)
}
\arguments{
\item{vars}{Variables to be summarized given as a character vector. Factors are handled as categorical variables, whereas numeric variables are handled as continuous variables. If empty, all variables in the data frame specified in the data argument are used.}

\item{strata}{Stratifying grouping variable name(s) given as a character vector. If omitted, the overall results are returned.}

\item{strata2}{Stratifying 2nd grouping variable name(s) given as a character vector. If omitted, the 1 group results are returned.}

\item{data}{A data frame in which these variables exist. All variables (both vars and strata) must be in this data frame.}

\item{factorVars}{Numerically coded variables that should be handled as categorical variables given as a character vector. Do not include factors, unless you need to relevel them by removing empty levels. If omitted, only factors are considered categorical variables. The variables specified here must also be specified in the vars argument.}

\item{includeNA}{If TRUE, NA is handled as a regular factor level rather than missing. NA is shown as the last factor level in the table. Only effective for categorical variables., Default: F}

\item{test}{If TRUE, as in the default and there are more than two groups, groupwise comparisons are performed, Default: T}

\item{showAllLevels}{Whether to show all levels. FALSE by default, i.e., for 2-level categorical variables, only the higher level is shown to avoid redundant information., Default: T}

\item{printToggle}{Whether to print the output. If FALSE, no output is created, and a matrix is invisibly returned., Default: F}

\item{quote}{Whether to show everything in quotes. The default is FALSE. If TRUE, everything including the row and column names are quoted so that you can copy it to Excel easily, Default: F}

\item{smd}{If TRUE, as in the default and there are more than two groups, standardized mean differences for all pairwise comparisons are calculated, Default: F}

\item{Labels}{Use Label, Default: F}

\item{nonnormal}{A character vector to specify the variables for which the p-values should be those of nonparametric tests. By default all p-values are from normal assumption-based tests (oneway.test)., Default: NULL}

\item{catDigits}{Number of digits to print for proportions., Default: 1}

\item{contDigits}{Number of digits to print for continuous variables. Default 2.}

\item{pDigits}{Number of digits to print for p-values (also used for standardized mean differences), Default: 3}

\item{labeldata}{labeldata to use, Default: NULL}

\item{psub}{show sub-group p-values, Default: F}

\item{minMax}{Whether to use [min,max] instead of [p25,p75] for nonnormal variables. The default is FALSE.}
}
\value{
A matrix object containing what you see is also invisibly returned. This can be assinged a name and exported via write.csv.
}
\description{
Combine svyCreateTableOne & print function in tableone package
}
\details{
DETAILS
}
\examples{
 library(survey);data(nhanes)
 nhanes$SDMVPSU <- as.factor(nhanes$SDMVPSU)
 nhanesSvy <- svydesign(ids = ~ SDMVPSU, strata = ~ SDMVSTRA, weights = ~ WTMEC2YR, 
                        nest = TRUE, data = nhanes)
 svyCreateTableOneJS(vars = c("HI_CHOL","race","agecat","RIAGENDR"), 
                     strata = "RIAGENDR", data = nhanesSvy)
}
