% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kaplan.R
\name{ggplotdownUI}
\alias{ggplotdownUI}
\title{ggplotdownUI: Option & download module UI for ggplot}
\usage{
ggplotdownUI(id)
}
\arguments{
\item{id}{id}
}
\value{
Option & download module UI for ggplot
}
\description{
Option & download module UI for ggplot
}
\details{
Option & download module UI for ggplot
}
\examples{
library(shiny)
library(DT)
library(data.table)
library(jstable)
library(ggplot2)
ui <- fluidPage(
  sidebarLayout(
    sidebarPanel(
      kaplanUI("kaplan")
    ),
    mainPanel(
      plotOutput("kaplan_plot"),
      ggplotdownUI("kaplan")
    )
  )
)

server <- function(input, output, session) {
  data <- reactive(mtcars)
  data.label <- reactive(jstable::mk.lev(mtcars))

  out_kaplan <- callModule(kaplanModule, "kaplan",
    data = data, data_label = data.label,
    data_varStruct = NULL
  )

  output$kaplan_plot <- renderPlot({
    print(out_kaplan())
  })
}
}
