% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/histogram.R
\name{histogramUI}
\alias{histogramUI}
\title{histogramUI: shiny module UI for histogram}
\usage{
histogramUI(id, label = "histogram")
}
\arguments{
\item{id}{id}

\item{label}{label}
}
\value{
Shiny module UI for histogram
}
\description{
Shiny module UI for histogram
}
\details{
Shiny module UI for histogram
}
\examples{
library(shiny)
library(ggplot2)
library(ggpubr)
ui <- fluidPage(
  sidebarLayout(
    sidebarPanel(
      histogramUI("histogram")
    ),
    mainPanel(
      plotOutput("histogram"),
      ggplotdownUI("histogram")
    )
  )
)

server <- function(input, output, session) {
  data <- reactive(mtcars)
  data.label <- reactive(jstable::mk.lev(mtcars))

  out_histogram <- histogramServer("histogram",
    data = data, data_label = data.label,
    data_varStruct = NULL
  )

  output$histogram <- renderPlot({
    print(out_histogram())
  })
}
}
