% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/csvFileInput.R
\name{csvFileInput}
\alias{csvFileInput}
\title{csvFileInput: Shiny module UI for file upload.}
\usage{
csvFileInput(id, label = "Upload data (csv/xlsx/sav/sas7bdat/dta)")
}
\arguments{
\item{id}{id}

\item{label}{label, Default: 'csv/xlsx/sav/sas7bdat/dta file'}
}
\value{
Shiny module UI for file(csv or xlsx) upload.
}
\description{
Shiny module UI for file(csv or xlsx) upload.
}
\details{
Shiny module UI for file(csv or xlsx) upload.
}
\examples{
library(shiny);library(DT);library(data.table);library(readxl);library(jstable)
ui <- fluidPage(
  sidebarLayout(
    sidebarPanel(
      csvFileInput("datafile")
    ),
    mainPanel(
      tabsetPanel(type = "pills",
                  tabPanel("Data", DTOutput("data")),
                  tabPanel("Label", DTOutput("data_label", width = "100\%"))
                 )
   )
 )
)

server <- function(input, output, session) {
  data <- callModule(csvFile, "datafile")

  output$data <- renderDT({
    data()$data
  })

  output$label <- renderDT({
    data()$label
  })
}
}
