% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/treeNavigator.R
\name{treeNavigator-module}
\alias{treeNavigator-module}
\alias{treeNavigatorUI}
\alias{treeNavigatorServer}
\title{Tree navigator (Shiny module)}
\usage{
treeNavigatorUI(id, width = "100\%", height = "auto")

treeNavigatorServer(
  id,
  rootFolder,
  search = TRUE,
  wholerow = FALSE,
  contextMenu = FALSE,
  theme = "proton",
  pattern = NULL,
  all.files = TRUE,
  ...
)
}
\arguments{
\item{id}{an ID string; the one passed to \code{treeNavigatorUI} and
the one passed to \code{treeNavigatorServer} must be identical,
must not contain the \code{"-"} character, and must be a valid HTML
id attribute}

\item{width, height}{arguments passed to \code{\link{jstreeOutput}}}

\item{rootFolder}{path to the root folder in which you want to
navigate}

\item{search, wholerow, contextMenu}{arguments passed to \code{\link{jstree}}}

\item{theme}{the \strong{jsTree} theme, \code{"default"} or \code{"proton"}}

\item{pattern, all.files}{arguments passed to \code{\link[base]{list.files}}}

\item{...}{values passed to \code{\link[shiny]{req}}}
}
\value{
The \code{treeNavigatorUI} function returns a \code{shiny.tag.list}
  object to be included in a Shiny UI definition, and the function
  \code{treeNavigatorServer}, to be included in a Shiny server definition,
  returns a reactive value containing the selected file paths of the tree
  navigator.
}
\description{
A Shiny module allowing to render a files and folders
  navigator in the server side file system.
}
\examples{
library(shiny)
library(jsTreeR)

css <- HTML("
  .flexcol {
    display: flex;
    flex-direction: column;
    width: 100\%;
    margin: 0;
  }
  .stretch {
    flex-grow: 1;
    height: 1px;
  }
  .bottomright {
    position: fixed;
    bottom: 0;
    right: 15px;
    min-width: calc(50\% - 15px);
  }
")

ui <- fixedPage(
  tags$head(
    tags$style(css)
  ),
  class = "flexcol",

  br(),

  fixedRow(
    column(
      width = 6,
      treeNavigatorUI("explorer")
    ),
    column(
      width = 6,
      tags$div(class = "stretch"),
      tags$fieldset(
        class = "bottomright",
        tags$legend(
          tags$h1("Selections:", style = "float: left;"),
          downloadButton(
            "dwnld",
            class = "btn-primary btn-lg",
            style = "float: right;",
            icon  = icon("save")
          )
        ),
        verbatimTextOutput("selections")
      )
    )
  )
)
server <- function(input, output, session){

  Paths <- treeNavigatorServer(
    "explorer", rootFolder = getwd(),
    search = list( # (search in the visited folders only)
      show_only_matches  = TRUE,
      case_sensitive     = TRUE,
      search_leaves_only = TRUE
    )
  )

  output[["selections"]] <- renderPrint({
    cat(Paths(), sep = "\n")
  })

  output[["dwnld"]] <- downloadHandler(
    filename = "myArchive.zip",
    content = function(file){
      zip(file, files = Paths())
    }
  )

}

if(interactive()) shinyApp(ui, server)
}
