% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jstree-shiny.R
\name{jstree-shiny}
\alias{jstree-shiny}
\alias{jstreeOutput}
\alias{renderJstree}
\title{Shiny bindings for jstree}
\usage{
jstreeOutput(outputId, width = "100\%", height = "auto")

renderJstree(expr, env = parent.frame(), quoted = FALSE)
}
\arguments{
\item{outputId}{output variable to read from}

\item{width, height}{must be a valid CSS unit (like \code{'100\%'},
\code{'400px'}, \code{'auto'}) or a number, which will be coerced to a
string and have \code{'px'} appended}

\item{expr}{an expression that generates a \code{\link{jstree}}}

\item{env}{the environment in which to evaluate \code{expr}}

\item{quoted}{logical, whether \code{expr} is a quoted expression
(with \code{quote()}); this is useful if you want to save an expression
in a variable}
}
\value{
\code{jstreeOutput} returns an output element that can be included
  in a Shiny UI definition, and \code{renderJstree} returns a
  \code{shiny.render.function} object that can be included in a Shiny server
  definition.
}
\description{
Output and render functions for using \code{jstree} within
  Shiny applications and interactive Rmd documents. See examples with
  \code{\link{jstreeExample}}.
}
