% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/esprima.R
\name{esprima}
\alias{esprima}
\alias{esprima_tokenize}
\alias{esprima_parse}
\title{JavaScrip Syntax Tree}
\usage{
esprima_tokenize(text, ...)

esprima_parse(text, ...)
}
\arguments{
\item{text}{a character vector with JavaScript code}

\item{...}{additional arguments for the \href{http://esprima.readthedocs.io/en/4.0/lexical-analysis.html}{tokenizer}}
}
\description{
\href{https://www.npmjs.com/package/esprima}{Esprima} is a high performance, standard-compliant
ECMAScript parser. It has full support for ECMAScript 2017 and returns a sensible syntax tree
format as standardized by ESTree project.
}
\details{
The \code{esprima_tokenize} function returns a data frame with JavaScript tokens. The
\code{esprima_parse} function returns the Syntax Tree in JSON format. This can be parsed to R
using e.g. \code{jsonlite::fromJSON}.
}
\examples{
code <- "function test(x, y){ x = x || 1; y = y || 1; return x*y;}"
esprima_tokenize(code)
esprima_parse(code)
}
\references{
Esprima documentation: \url{http://esprima.readthedocs.io/en/4.0/}.
}
