% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jrSiCKLSNMF.R
\name{RunjrSiCKLSNMF}
\alias{RunjrSiCKLSNMF}
\title{Run jrSiCKLSNMF on an object of class SickleJr}
\usage{
RunjrSiCKLSNMF(
  SickleJr,
  rounds = 30000,
  differr = 1e-06,
  display_progress = TRUE,
  lossonsubset = FALSE,
  losssubsetsize = dim(SickleJr@H)[1],
  minibatch = FALSE,
  batchsize = 1000,
  random_W_updates = FALSE,
  seed = NULL,
  minrounds = 200,
  suppress_warnings = FALSE,
  subsample = 1:dim(SickleJr@normalized.count.matrices[[1]])[2]
)
}
\arguments{
\item{SickleJr}{An object of class SickleJr}

\item{rounds}{Number of rounds: defaults to 2000}

\item{differr}{Tolerance for percentage change in loss between updates: defaults to 1e-6}

\item{display_progress}{Boolean indicating whether to display the progress bar for jrSiCKLSNMF}

\item{lossonsubset}{Boolean indicating whether to use a subset to calculate the loss function
rather than the whole dataset}

\item{losssubsetsize}{Size of the subset of data on which to calculate the loss}

\item{minibatch}{Boolean indicating whether to use mini-batch updates}

\item{batchsize}{Size of batch for mini-batch updates}

\item{random_W_updates}{Boolean indicating whether or not to use random_W_updates updates
(i.e. only update \eqn{\mathbf{W}^v} once per mini-batch epoch)}

\item{seed}{Number specifying desired random seed}

\item{minrounds}{Minimum number of rounds: most helpful for the mini-batch algorithm}

\item{suppress_warnings}{Boolean indicating whether to suppress warnings}

\item{subsample}{A numeric used primarily when finding an appropriate number of
latent factors: defaults to total number of cells}
}
\value{
An object of class SickleJr with updated \eqn{\mathbf{W}^v} matrices, updated \eqn{\mathbf{H}} matrix, and a vector of values for
the loss function added to the \code{Wlist}, \code{H}, and \code{loss} slots, respectively
}
\description{
Wrapper function to run jrSiCKLSNMF on an object of class SickleJr. Performs jrSiCKLSNMF on
the given SickleJr
}
\examples{
SimSickleJrSmall<-RunjrSiCKLSNMF(SimSickleJrSmall,rounds=5)
}
\references{
\insertRef{Cai2008}{jrSiCKLSNMF}

\insertRef{jnmf2009}{jrSiCKLSNMF}

\insertRef{Eddelbuettel2011}{jrSiCKLSNMF}

\insertRef{Eddelbuettel2014}{jrSiCKLSNMF}

\insertRef{Elyanow2020}{jrSiCKLSNMF}

\insertRef{halfbakednmf}{jrSiCKLSNMF}

\insertRef{Lee1999}{jrSiCKLSNMF}

\insertRef{Liu2013}{jrSiCKLSNMF}
}
