% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vars.R
\name{vars}
\alias{vars}
\alias{vars_}
\title{Variables}
\usage{
vars(.data, ...)

vars_(.data, ..., .dots)
}
\arguments{
\item{.data}{input. This can be JSON input, or an object of class
\code{jqr} that has JSON and query params combined, which is passed
from function to function when using the jqr DSL.}

\item{...}{Comma separated list of unquoted variable names}

\item{.dots}{Used to work around non-standard evaluation}

\item{dots}{dots}
}
\description{
Variables
}
\examples{
x <- '{
 "posts": [
   {"title": "Frist psot", "author": "anon"},
   {"title": "A well-written article", "author": "person1"}
 ],
 "realnames": {
   "anon": "Anonymous Coward",
   "person1": "Person McPherson"
 }
}'

x \%>\% dotstr(posts[])
x \%>\% dotstr(posts[]) \%>\% string
x \%>\% vars(realnames = names) \%>\% dotstr(posts[]) \%>\%
   select(title, author = "$names[.author]")
}
