
# This file is automatically generated, you probably don't want to edit this

ttestPSOptions <- if (requireNamespace('jmvcore')) R6::R6Class(
    "ttestPSOptions",
    inherit = jmvcore::Options,
    public = list(
        initialize = function(
            pairs = NULL,
            students = TRUE,
            bf = FALSE,
            bfPrior = 0.707,
            wilcoxon = FALSE,
            hypothesis = "different",
            norm = FALSE,
            qq = FALSE,
            meanDiff = FALSE,
            ci = FALSE,
            ciWidth = 95,
            effectSize = FALSE,
            ciES = FALSE,
            ciWidthES = 95,
            desc = FALSE,
            plots = FALSE,
            miss = "perAnalysis", ...) {

            super$initialize(
                package='jmv',
                name='ttestPS',
                requiresData=TRUE,
                ...)

            private$..pairs <- jmvcore::OptionPairs$new(
                "pairs",
                pairs,
                suggested=list(
                    "continuous"),
                permitted=list(
                    "numeric"))
            private$..students <- jmvcore::OptionBool$new(
                "students",
                students,
                default=TRUE)
            private$..bf <- jmvcore::OptionBool$new(
                "bf",
                bf,
                default=FALSE)
            private$..bfPrior <- jmvcore::OptionNumber$new(
                "bfPrior",
                bfPrior,
                default=0.707,
                min=0.5,
                max=2)
            private$..wilcoxon <- jmvcore::OptionBool$new(
                "wilcoxon",
                wilcoxon,
                default=FALSE)
            private$..hypothesis <- jmvcore::OptionList$new(
                "hypothesis",
                hypothesis,
                options=list(
                    "different",
                    "oneGreater",
                    "twoGreater"),
                default="different")
            private$..norm <- jmvcore::OptionBool$new(
                "norm",
                norm,
                default=FALSE)
            private$..qq <- jmvcore::OptionBool$new(
                "qq",
                qq,
                default=FALSE)
            private$..meanDiff <- jmvcore::OptionBool$new(
                "meanDiff",
                meanDiff,
                default=FALSE)
            private$..ci <- jmvcore::OptionBool$new(
                "ci",
                ci,
                default=FALSE)
            private$..ciWidth <- jmvcore::OptionNumber$new(
                "ciWidth",
                ciWidth,
                min=50,
                max=99.9,
                default=95)
            private$..effectSize <- jmvcore::OptionBool$new(
                "effectSize",
                effectSize,
                default=FALSE)
            private$..ciES <- jmvcore::OptionBool$new(
                "ciES",
                ciES,
                default=FALSE)
            private$..ciWidthES <- jmvcore::OptionNumber$new(
                "ciWidthES",
                ciWidthES,
                min=50,
                max=99.9,
                default=95)
            private$..desc <- jmvcore::OptionBool$new(
                "desc",
                desc,
                default=FALSE)
            private$..plots <- jmvcore::OptionBool$new(
                "plots",
                plots,
                default=FALSE)
            private$..miss <- jmvcore::OptionList$new(
                "miss",
                miss,
                options=list(
                    "perAnalysis",
                    "listwise"),
                default="perAnalysis")

            self$.addOption(private$..pairs)
            self$.addOption(private$..students)
            self$.addOption(private$..bf)
            self$.addOption(private$..bfPrior)
            self$.addOption(private$..wilcoxon)
            self$.addOption(private$..hypothesis)
            self$.addOption(private$..norm)
            self$.addOption(private$..qq)
            self$.addOption(private$..meanDiff)
            self$.addOption(private$..ci)
            self$.addOption(private$..ciWidth)
            self$.addOption(private$..effectSize)
            self$.addOption(private$..ciES)
            self$.addOption(private$..ciWidthES)
            self$.addOption(private$..desc)
            self$.addOption(private$..plots)
            self$.addOption(private$..miss)
        }),
    active = list(
        pairs = function() private$..pairs$value,
        students = function() private$..students$value,
        bf = function() private$..bf$value,
        bfPrior = function() private$..bfPrior$value,
        wilcoxon = function() private$..wilcoxon$value,
        hypothesis = function() private$..hypothesis$value,
        norm = function() private$..norm$value,
        qq = function() private$..qq$value,
        meanDiff = function() private$..meanDiff$value,
        ci = function() private$..ci$value,
        ciWidth = function() private$..ciWidth$value,
        effectSize = function() private$..effectSize$value,
        ciES = function() private$..ciES$value,
        ciWidthES = function() private$..ciWidthES$value,
        desc = function() private$..desc$value,
        plots = function() private$..plots$value,
        miss = function() private$..miss$value),
    private = list(
        ..pairs = NA,
        ..students = NA,
        ..bf = NA,
        ..bfPrior = NA,
        ..wilcoxon = NA,
        ..hypothesis = NA,
        ..norm = NA,
        ..qq = NA,
        ..meanDiff = NA,
        ..ci = NA,
        ..ciWidth = NA,
        ..effectSize = NA,
        ..ciES = NA,
        ..ciWidthES = NA,
        ..desc = NA,
        ..plots = NA,
        ..miss = NA)
)

ttestPSResults <- if (requireNamespace('jmvcore')) R6::R6Class(
    inherit = jmvcore::Group,
    active = list(
        ttest = function() private$.items[["ttest"]],
        norm = function() private$.items[["norm"]],
        desc = function() private$.items[["desc"]],
        plots = function() private$.items[["plots"]]),
    private = list(),
    public=list(
        initialize=function(options) {
            super$initialize(
                options=options,
                name="",
                title="Paired Samples T-Test")
            self$add(jmvcore::Table$new(
                options=options,
                name="ttest",
                title="Paired Samples T-Test",
                rows="(pairs)",
                clearWith=list(
                    "miss",
                    "hypothesis",
                    "ciWidth",
                    "bfPrior",
                    "ciWidthES"),
                columns=list(
                    list(
                        `name`="var1[stud]", 
                        `title`="", 
                        `type`="text", 
                        `combineBelow`=TRUE, 
                        `visible`="(students)"),
                    list(
                        `name`="var2[stud]", 
                        `title`="", 
                        `type`="text", 
                        `combineBelow`=TRUE, 
                        `visible`="(students)"),
                    list(
                        `name`="test[stud]", 
                        `title`="", 
                        `type`="text", 
                        `content`="Student's t", 
                        `visible`="(students)"),
                    list(
                        `name`="stat[stud]", 
                        `title`="statistic", 
                        `type`="number", 
                        `visible`="(students)"),
                    list(
                        `name`="err[stud]", 
                        `title`="error %", 
                        `type`="number", 
                        `visible`="(students && bf)", 
                        `content`=""),
                    list(
                        `name`="df[stud]", 
                        `title`="df", 
                        `type`="number", 
                        `visible`="(students)"),
                    list(
                        `name`="p[stud]", 
                        `title`="p", 
                        `type`="number", 
                        `format`="zto,pvalue", 
                        `visible`="(students)"),
                    list(
                        `name`="md[stud]", 
                        `title`="Mean difference", 
                        `type`="number", 
                        `visible`="(meanDiff && students)"),
                    list(
                        `name`="sed[stud]", 
                        `title`="SE difference", 
                        `type`="number", 
                        `visible`="(meanDiff && students)"),
                    list(
                        `name`="cil[stud]", 
                        `title`="Lower", 
                        `type`="number", 
                        `visible`="(ci && meanDiff && students)"),
                    list(
                        `name`="ciu[stud]", 
                        `title`="Upper", 
                        `type`="number", 
                        `visible`="(ci && meanDiff && students)"),
                    list(
                        `name`="es[stud]", 
                        `title`="Cohen's d", 
                        `type`="number", 
                        `visible`="(effectSize && students)"),
                    list(
                        `name`="ciles[stud]", 
                        `title`="Lower", 
                        `type`="number", 
                        `visible`="(ciES && effectSize && students)"),
                    list(
                        `name`="ciues[stud]", 
                        `title`="Upper", 
                        `type`="number", 
                        `visible`="(ciES && effectSize && students)"),
                    list(
                        `name`="var1[bf]", 
                        `title`="", 
                        `type`="text", 
                        `combineBelow`=TRUE, 
                        `visible`="(bf)"),
                    list(
                        `name`="var2[bf]", 
                        `title`="", 
                        `type`="text", 
                        `combineBelow`=TRUE, 
                        `visible`="(bf)"),
                    list(
                        `name`="test[bf]", 
                        `title`="", 
                        `type`="text", 
                        `content`="Bayes factor\u2081\u2080", 
                        `visible`="(bf)"),
                    list(
                        `name`="stat[bf]", 
                        `title`="Statistic", 
                        `type`="number", 
                        `visible`="(bf)", 
                        `refs`=list(
                            "BF",
                            "btt")),
                    list(
                        `name`="err[bf]", 
                        `title`="\u00B1%", 
                        `type`="number", 
                        `visible`="(bf)"),
                    list(
                        `name`="df[bf]", 
                        `title`="df", 
                        `type`="number", 
                        `visible`="(bf)", 
                        `content`=""),
                    list(
                        `name`="p[bf]", 
                        `title`="p", 
                        `type`="number", 
                        `format`="zto,pvalue", 
                        `visible`="(bf)", 
                        `content`=""),
                    list(
                        `name`="md[bf]", 
                        `title`="Mean difference", 
                        `type`="number", 
                        `visible`="(meanDiff && bf)", 
                        `content`=""),
                    list(
                        `name`="sed[bf]", 
                        `title`="SE difference", 
                        `type`="number", 
                        `visible`="(meanDiff && bf)", 
                        `content`=""),
                    list(
                        `name`="cil[bf]", 
                        `title`="Lower", 
                        `type`="number", 
                        `visible`="(ci && meanDiff && bf)", 
                        `content`=""),
                    list(
                        `name`="ciu[bf]", 
                        `title`="Upper", 
                        `type`="number", 
                        `visible`="(ci && meanDiff && bf)", 
                        `content`=""),
                    list(
                        `name`="es[bf]", 
                        `title`="Cohen's d", 
                        `type`="number", 
                        `visible`="(effectSize && bf)", 
                        `content`=""),
                    list(
                        `name`="ciles[bf]", 
                        `title`="Lower", 
                        `type`="number", 
                        `visible`="(ciES && effectSize && bf)", 
                        `content`=""),
                    list(
                        `name`="ciues[bf]", 
                        `title`="Upper", 
                        `type`="number", 
                        `visible`="(ciES && effectSize && bf)", 
                        `content`=""),
                    list(
                        `name`="var1[wilc]", 
                        `title`="", 
                        `type`="text", 
                        `combineBelow`=TRUE, 
                        `visible`="(wilcoxon)"),
                    list(
                        `name`="var2[wilc]", 
                        `title`="", 
                        `type`="text", 
                        `combineBelow`=TRUE, 
                        `visible`="(wilcoxon)"),
                    list(
                        `name`="test[wilc]", 
                        `type`="text", 
                        `title`="", 
                        `content`="Wilcoxon W", 
                        `visible`="(wilcoxon)"),
                    list(
                        `name`="stat[wilc]", 
                        `title`="Statistic", 
                        `type`="number", 
                        `visible`="(wilcoxon)"),
                    list(
                        `name`="err[wilc]", 
                        `title`="\u00B1%", 
                        `type`="number", 
                        `visible`="(wilcoxon && bf)", 
                        `content`=""),
                    list(
                        `name`="p[wilc]", 
                        `title`="p", 
                        `type`="number", 
                        `format`="zto,pvalue", 
                        `visible`="(wilcoxon)"),
                    list(
                        `name`="md[wilc]", 
                        `title`="Mean difference", 
                        `type`="number", 
                        `visible`="(meanDiff && wilcoxon)"),
                    list(
                        `name`="sed[wilc]", 
                        `title`="SE difference", 
                        `type`="number", 
                        `visible`="(meanDiff && wilcoxon)"),
                    list(
                        `name`="cil[wilc]", 
                        `title`="Lower", 
                        `type`="number", 
                        `visible`="(ci && meanDiff && wilcoxon)"),
                    list(
                        `name`="ciu[wilc]", 
                        `title`="Upper", 
                        `type`="number", 
                        `visible`="(ci && meanDiff && wilcoxon)"),
                    list(
                        `name`="es[wilc]", 
                        `title`="Cohen's d", 
                        `type`="number", 
                        `visible`="(effectSize && wilcoxon)"),
                    list(
                        `name`="ciles[wilc]", 
                        `title`="Lower", 
                        `type`="number", 
                        `visible`="(ciES && effectSize && wilcoxon)"),
                    list(
                        `name`="ciues[wilc]", 
                        `title`="Upper", 
                        `type`="number", 
                        `visible`="(ciES && effectSize && wilcoxon)"))))
            self$add(jmvcore::Table$new(
                options=options,
                name="norm",
                title="Normality Test (Shapiro-Wilk)",
                visible="(norm)",
                rows="(pairs)",
                notes=list(
                    `p`="A low p-value suggests a violation of the assumption of normality"),
                clearWith=list(
                    "miss"),
                columns=list(
                    list(
                        `name`="var1", 
                        `title`="", 
                        `type`="text"),
                    list(
                        `name`="sep", 
                        `title`="", 
                        `type`="text", 
                        `content`="-", 
                        `format`="narrow"),
                    list(
                        `name`="var2", 
                        `title`="", 
                        `type`="text"),
                    list(
                        `name`="w", 
                        `title`="W", 
                        `type`="number"),
                    list(
                        `name`="p", 
                        `type`="number", 
                        `format`="zto,pvalue"))))
            self$add(jmvcore::Table$new(
                options=options,
                name="desc",
                title="Descriptives",
                visible="(desc)",
                clearWith=list(
                    "miss"),
                columns=list(
                    list(
                        `name`="name", 
                        `title`="", 
                        `content`=".", 
                        `type`="text"),
                    list(
                        `name`="num", 
                        `title`="N", 
                        `type`="integer"),
                    list(
                        `name`="m", 
                        `title`="Mean", 
                        `type`="number"),
                    list(
                        `name`="med", 
                        `title`="Median", 
                        `type`="number"),
                    list(
                        `name`="sd", 
                        `title`="SD", 
                        `type`="number"),
                    list(
                        `name`="se", 
                        `title`="SE", 
                        `type`="number"))))
            self$add(jmvcore::Array$new(
                options=options,
                name="plots",
                title="Plots",
                items="(pairs)",
                clearWith=list(
                    "miss"),
                template=R6::R6Class(
                    inherit = jmvcore::Group,
                    active = list(
                        desc = function() private$.items[["desc"]],
                        qq = function() private$.items[["qq"]]),
                    private = list(),
                    public=list(
                        initialize=function(options) {
                            super$initialize(
                                options=options,
                                name="undefined",
                                title="no title")
                            self$add(jmvcore::Image$new(
                                options=options,
                                name="desc",
                                visible="(plots)",
                                renderFun=".desc",
                                clearWith=list()))
                            self$add(jmvcore::Image$new(
                                options=options,
                                name="qq",
                                visible="(qq)",
                                width=350,
                                height=300,
                                requiresData=TRUE,
                                renderFun=".qq",
                                clearWith=list()))}))$new(options=options)))}))

ttestPSBase <- if (requireNamespace('jmvcore')) R6::R6Class(
    "ttestPSBase",
    inherit = jmvcore::Analysis,
    public = list(
        initialize = function(options, data=NULL, datasetId="", analysisId="", revision=0) {
            super$initialize(
                package = 'jmv',
                name = 'ttestPS',
                version = c(1,0,0),
                options = options,
                results = ttestPSResults$new(options=options),
                data = data,
                datasetId = datasetId,
                analysisId = analysisId,
                revision = revision,
                pause = NULL,
                completeWhenFilled = TRUE,
                requiresMissings = FALSE)
        }))

#' Paired Samples T-Test
#'
#' The Student's paired samples t-test (sometimes called a
#' dependent-samples t-test) is used to test the null hypothesis that the
#' difference between pairs of measurements is equal to zero. A low p-value
#' suggests that the null hypothesis is not true, and that the
#' difference between the measurement pairs is not zero.
#' 
#' The Student's paired samples t-test assumes that pair differences follow
#' a normal distribution -- in the case that one is unwilling to assume
#' this, the non-parametric Wilcoxon signed-rank can be used in it's place
#' (However, note that the Wilcoxon signed-rank has a slightly different
#' null hypothesis; that the two groups of measurements follow the same
#' distribution).
#' 
#'
#' @examples
#' \dontrun{
#' data('bugs', package = 'jmv')
#'
#' ttestPS(bugs, pairs = list(
#'         list(i1 = 'LDLF', i2 = 'LDHF')))
#'
#' #
#' #  PAIRED SAMPLES T-TEST
#' #
#' #  Paired Samples T-Test
#' #  --------------------------------------------------------------
#' #                                   statistic    df      p
#' #  --------------------------------------------------------------
#' #    LDLF    LDHF    Student's t        -6.65    90.0    < .001
#' #  --------------------------------------------------------------
#' #
#'}
#' @param data the data as a data frame
#' @param pairs a list of lists specifying the pairs of measurement in
#'   \code{data}
#' @param students \code{TRUE} (default) or \code{FALSE}, perform Student's
#'   t-tests
#' @param bf \code{TRUE} or \code{FALSE} (default), provide Bayes factors
#' @param bfPrior a number between 0.5 and 2 (default 0.707), the prior width
#'   to use in calculating Bayes factors
#' @param wilcoxon \code{TRUE} or \code{FALSE} (default), perform Wilcoxon
#'   signed rank tests
#' @param hypothesis \code{'different'} (default), \code{'oneGreater'} or
#'   \code{'twoGreater'}, the alternative hypothesis; measure 1 different to
#'   measure 2, measure 1 greater than measure 2, and measure 2 greater than
#'   measure 1 respectively
#' @param norm \code{TRUE} or \code{FALSE} (default), perform Shapiro-wilk
#'   normality tests
#' @param qq \code{TRUE} or \code{FALSE} (default), provide a Q-Q plot of
#'   residuals
#' @param meanDiff \code{TRUE} or \code{FALSE} (default), provide means and
#'   standard errors
#' @param ci \code{TRUE} or \code{FALSE} (default), provide confidence
#'   intervals
#' @param ciWidth a number between 50 and 99.9 (default: 95), the width of
#'   confidence intervals
#' @param effectSize \code{TRUE} or \code{FALSE} (default), provide effect
#'   sizes
#' @param ciES \code{TRUE} or \code{FALSE} (default), provide confidence
#'   intervals for the effect-sizes
#' @param ciWidthES a number between 50 and 99.9 (default: 95), the width of
#'   confidence intervals for the effect sizes
#' @param desc \code{TRUE} or \code{FALSE} (default), provide descriptive
#'   statistics
#' @param plots \code{TRUE} or \code{FALSE} (default), provide descriptive
#'   plots
#' @param miss \code{'perAnalysis'} or \code{'listwise'}, how to handle
#'   missing values; \code{'perAnalysis'} excludes missing values for individual
#'   dependent variables, \code{'listwise'} excludes a row from all analyses if
#'   one of its entries is missing
#' @return A results object containing:
#' \tabular{llllll}{
#'   \code{results$ttest} \tab \tab \tab \tab \tab a table containing the t-test results \cr
#'   \code{results$norm} \tab \tab \tab \tab \tab a table containing the normality test results \cr
#'   \code{results$desc} \tab \tab \tab \tab \tab a table containing the descriptives \cr
#'   \code{results$plots} \tab \tab \tab \tab \tab an array of the descriptive plots \cr
#' }
#'
#' Tables can be converted to data frames with \code{asDF} or \code{\link{as.data.frame}}. For example:
#'
#' \code{results$ttest$asDF}
#'
#' \code{as.data.frame(results$ttest)}
#'
#' @export
ttestPS <- function(
    data,
    pairs,
    students = TRUE,
    bf = FALSE,
    bfPrior = 0.707,
    wilcoxon = FALSE,
    hypothesis = "different",
    norm = FALSE,
    qq = FALSE,
    meanDiff = FALSE,
    ci = FALSE,
    ciWidth = 95,
    effectSize = FALSE,
    ciES = FALSE,
    ciWidthES = 95,
    desc = FALSE,
    plots = FALSE,
    miss = "perAnalysis") {

    if ( ! requireNamespace('jmvcore'))
        stop('ttestPS requires jmvcore to be installed (restart may be required)')

    if (missing(data))
        data <- jmvcore::marshalData(
            parent.frame())


    options <- ttestPSOptions$new(
        pairs = pairs,
        students = students,
        bf = bf,
        bfPrior = bfPrior,
        wilcoxon = wilcoxon,
        hypothesis = hypothesis,
        norm = norm,
        qq = qq,
        meanDiff = meanDiff,
        ci = ci,
        ciWidth = ciWidth,
        effectSize = effectSize,
        ciES = ciES,
        ciWidthES = ciWidthES,
        desc = desc,
        plots = plots,
        miss = miss)

    analysis <- ttestPSClass$new(
        options = options,
        data = data)

    analysis$run()

    analysis$results
}
