
# This file is automatically generated, you probably don't want to edit this

anovaRMOptions <- if (requireNamespace('jmvcore')) R6::R6Class(
    "anovaRMOptions",
    inherit = jmvcore::Options,
    public = list(
        initialize = function(
            rm = list(
                list(label="RM Factor 1", levels=list(
                    "Level 1",
                    "Level 2"))),
            rmCells = NULL,
            bs = NULL,
            cov = NULL,
            effectSize = NULL,
            depLabel = "Dependent",
            rmTerms = NULL,
            bsTerms = NULL,
            ss = "3",
            spherTests = FALSE,
            spherCorr = list(
                "none"),
            leveneTest = FALSE,
            contrasts = NULL,
            postHoc = NULL,
            postHocCorr = list(
                "tukey"),
            emMeans = list(
                list()),
            emmPlots = TRUE,
            emmTables = FALSE,
            emmWeights = TRUE,
            ciWidthEmm = 95,
            emmPlotData = FALSE,
            emmPlotError = "ci", ...) {

            super$initialize(
                package='jmv',
                name='anovaRM',
                requiresData=TRUE,
                ...)

            private$..rm <- jmvcore::OptionArray$new(
                "rm",
                rm,
                default=list(
                    list(label="RM Factor 1", levels=list(
                        "Level 1",
                        "Level 2"))),
                template=jmvcore::OptionGroup$new(
                    "rm",
                    NULL,
                    elements=list(
                        jmvcore::OptionString$new(
                            "label",
                            NULL),
                        jmvcore::OptionArray$new(
                            "levels",
                            NULL,
                            template=jmvcore::OptionString$new(
                                "levels",
                                NULL)))))
            private$..rmCells <- jmvcore::OptionArray$new(
                "rmCells",
                rmCells,
                default=NULL,
                template=jmvcore::OptionGroup$new(
                    "rmCells",
                    NULL,
                    elements=list(
                        jmvcore::OptionVariable$new(
                            "measure",
                            NULL),
                        jmvcore::OptionArray$new(
                            "cell",
                            NULL,
                            template=jmvcore::OptionString$new(
                                "cell",
                                NULL)))))
            private$..bs <- jmvcore::OptionVariables$new(
                "bs",
                bs,
                rejectUnusedLevels=TRUE,
                suggested=list(
                    "nominal",
                    "ordinal"),
                permitted=list(
                    "factor"),
                default=NULL)
            private$..cov <- jmvcore::OptionVariables$new(
                "cov",
                cov,
                suggested=list(
                    "continuous"),
                permitted=list(
                    "numeric"),
                default=NULL)
            private$..effectSize <- jmvcore::OptionNMXList$new(
                "effectSize",
                effectSize,
                options=list(
                    "eta",
                    "partEta",
                    "omega"),
                default=NULL)
            private$..depLabel <- jmvcore::OptionString$new(
                "depLabel",
                depLabel,
                default="Dependent")
            private$..rmTerms <- jmvcore::OptionTerms$new(
                "rmTerms",
                rmTerms,
                default=NULL)
            private$..bsTerms <- jmvcore::OptionTerms$new(
                "bsTerms",
                bsTerms,
                default=NULL)
            private$..ss <- jmvcore::OptionList$new(
                "ss",
                ss,
                options=list(
                    "2",
                    "3"),
                default="3")
            private$..spherTests <- jmvcore::OptionBool$new(
                "spherTests",
                spherTests,
                default=FALSE)
            private$..spherCorr <- jmvcore::OptionNMXList$new(
                "spherCorr",
                spherCorr,
                options=list(
                    "none",
                    "GG",
                    "HF"),
                default=list(
                    "none"))
            private$..leveneTest <- jmvcore::OptionBool$new(
                "leveneTest",
                leveneTest,
                default=FALSE)
            private$..contrasts <- jmvcore::OptionArray$new(
                "contrasts",
                contrasts,
                hidden=TRUE,
                items="(bs)",
                default=NULL,
                template=jmvcore::OptionGroup$new(
                    "contrasts",
                    NULL,
                    elements=list(
                        jmvcore::OptionString$new(
                            "var",
                            NULL,
                            content="$key"),
                        jmvcore::OptionList$new(
                            "type",
                            NULL,
                            options=list(
                                "none",
                                "deviation",
                                "simple",
                                "difference",
                                "helmert",
                                "repeated",
                                "polynomial")))))
            private$..postHoc <- jmvcore::OptionArray$new(
                "postHoc",
                postHoc,
                template=jmvcore::OptionArray$new(
                    "postHoc",
                    NULL,
                    template=jmvcore::OptionString$new(
                        "postHoc",
                        NULL)),
                default=NULL)
            private$..postHocCorr <- jmvcore::OptionNMXList$new(
                "postHocCorr",
                postHocCorr,
                options=list(
                    "none",
                    "tukey",
                    "scheffe",
                    "bonf",
                    "holm"),
                default=list(
                    "tukey"))
            private$..emMeans <- jmvcore::OptionArray$new(
                "emMeans",
                emMeans,
                default=list(
                    list()),
                template=jmvcore::OptionVariables$new(
                    "emMeans",
                    NULL))
            private$..emmPlots <- jmvcore::OptionBool$new(
                "emmPlots",
                emmPlots,
                default=TRUE)
            private$..emmTables <- jmvcore::OptionBool$new(
                "emmTables",
                emmTables,
                default=FALSE)
            private$..emmWeights <- jmvcore::OptionBool$new(
                "emmWeights",
                emmWeights,
                default=TRUE)
            private$..ciWidthEmm <- jmvcore::OptionNumber$new(
                "ciWidthEmm",
                ciWidthEmm,
                min=50,
                max=99.9,
                default=95)
            private$..emmPlotData <- jmvcore::OptionBool$new(
                "emmPlotData",
                emmPlotData,
                default=FALSE)
            private$..emmPlotError <- jmvcore::OptionList$new(
                "emmPlotError",
                emmPlotError,
                options=list(
                    "none",
                    "ci",
                    "se"),
                default="ci")

            self$.addOption(private$..rm)
            self$.addOption(private$..rmCells)
            self$.addOption(private$..bs)
            self$.addOption(private$..cov)
            self$.addOption(private$..effectSize)
            self$.addOption(private$..depLabel)
            self$.addOption(private$..rmTerms)
            self$.addOption(private$..bsTerms)
            self$.addOption(private$..ss)
            self$.addOption(private$..spherTests)
            self$.addOption(private$..spherCorr)
            self$.addOption(private$..leveneTest)
            self$.addOption(private$..contrasts)
            self$.addOption(private$..postHoc)
            self$.addOption(private$..postHocCorr)
            self$.addOption(private$..emMeans)
            self$.addOption(private$..emmPlots)
            self$.addOption(private$..emmTables)
            self$.addOption(private$..emmWeights)
            self$.addOption(private$..ciWidthEmm)
            self$.addOption(private$..emmPlotData)
            self$.addOption(private$..emmPlotError)
        }),
    active = list(
        rm = function() private$..rm$value,
        rmCells = function() private$..rmCells$value,
        bs = function() private$..bs$value,
        cov = function() private$..cov$value,
        effectSize = function() private$..effectSize$value,
        depLabel = function() private$..depLabel$value,
        rmTerms = function() private$..rmTerms$value,
        bsTerms = function() private$..bsTerms$value,
        ss = function() private$..ss$value,
        spherTests = function() private$..spherTests$value,
        spherCorr = function() private$..spherCorr$value,
        leveneTest = function() private$..leveneTest$value,
        contrasts = function() private$..contrasts$value,
        postHoc = function() private$..postHoc$value,
        postHocCorr = function() private$..postHocCorr$value,
        emMeans = function() private$..emMeans$value,
        emmPlots = function() private$..emmPlots$value,
        emmTables = function() private$..emmTables$value,
        emmWeights = function() private$..emmWeights$value,
        ciWidthEmm = function() private$..ciWidthEmm$value,
        emmPlotData = function() private$..emmPlotData$value,
        emmPlotError = function() private$..emmPlotError$value),
    private = list(
        ..rm = NA,
        ..rmCells = NA,
        ..bs = NA,
        ..cov = NA,
        ..effectSize = NA,
        ..depLabel = NA,
        ..rmTerms = NA,
        ..bsTerms = NA,
        ..ss = NA,
        ..spherTests = NA,
        ..spherCorr = NA,
        ..leveneTest = NA,
        ..contrasts = NA,
        ..postHoc = NA,
        ..postHocCorr = NA,
        ..emMeans = NA,
        ..emmPlots = NA,
        ..emmTables = NA,
        ..emmWeights = NA,
        ..ciWidthEmm = NA,
        ..emmPlotData = NA,
        ..emmPlotError = NA)
)

anovaRMResults <- if (requireNamespace('jmvcore')) R6::R6Class(
    inherit = jmvcore::Group,
    active = list(
        rmTable = function() private$.items[["rmTable"]],
        bsTable = function() private$.items[["bsTable"]],
        assump = function() private$.items[["assump"]],
        contrasts = function() private$.items[["contrasts"]],
        postHoc = function() private$.items[["postHoc"]],
        emm = function() private$.items[["emm"]]),
    private = list(),
    public=list(
        initialize=function(options) {
            super$initialize(
                options=options,
                name="",
                title="Repeated Measures ANOVA")
            self$add(jmvcore::Table$new(
                options=options,
                name="rmTable",
                title="Within Subjects Effects",
                clearWith=list(
                    "dependent",
                    "ss",
                    "rmCells",
                    "rmcModelTerms",
                    "bscModelTerms",
                    "bs",
                    "rm",
                    "cov",
                    "rmTerms",
                    "bsTerms"),
                columns=list(
                    list(
                        `name`="name[none]", 
                        `title`="", 
                        `type`="text", 
                        `combineBelow`=TRUE, 
                        `visible`="(spherCorr:none)"),
                    list(
                        `name`="correction[none]", 
                        `title`="Sphericity Correction", 
                        `type`="text", 
                        `content`="None", 
                        `visible`="(spherCorr:none && (spherCorr:GG || spherCorr:HF))"),
                    list(
                        `name`="ss[none]", 
                        `title`="Sum of Squares", 
                        `type`="number", 
                        `visible`="(spherCorr:none)"),
                    list(
                        `name`="df[none]", 
                        `title`="df", 
                        `type`="integer", 
                        `visible`="(spherCorr:none)"),
                    list(
                        `name`="ms[none]", 
                        `title`="Mean Square", 
                        `type`="number", 
                        `visible`="(spherCorr:none)"),
                    list(
                        `name`="F[none]", 
                        `title`="F", 
                        `type`="number", 
                        `visible`="(spherCorr:none)"),
                    list(
                        `name`="p[none]", 
                        `title`="p", 
                        `type`="number", 
                        `format`="zto,pvalue", 
                        `visible`="(spherCorr:none)"),
                    list(
                        `name`="eta[none]", 
                        `title`="\u03B7\u00B2", 
                        `type`="number", 
                        `format`="zto", 
                        `visible`="(effectSize:eta && spherCorr:none)"),
                    list(
                        `name`="partEta[none]", 
                        `title`="partial \u03B7\u00B2", 
                        `type`="number", 
                        `format`="zto", 
                        `visible`="(effectSize:partEta && spherCorr:none)"),
                    list(
                        `name`="omega[none]", 
                        `title`="\u03C9\u00B2", 
                        `type`="number", 
                        `format`="zto", 
                        `visible`="(effectSize:omega && spherCorr:none)"),
                    list(
                        `name`="name[GG]", 
                        `title`="", 
                        `type`="text", 
                        `combineBelow`=TRUE, 
                        `visible`="(spherCorr:GG)"),
                    list(
                        `name`="correction[GG]", 
                        `title`="Sphericity Correction", 
                        `type`="text", 
                        `content`="Greenhouse-Geisser", 
                        `visible`="(spherCorr:GG)"),
                    list(
                        `name`="ss[GG]", 
                        `title`="Sum of Squares", 
                        `type`="number", 
                        `visible`="(spherCorr:GG)"),
                    list(
                        `name`="df[GG]", 
                        `title`="df", 
                        `type`="number", 
                        `visible`="(spherCorr:GG)"),
                    list(
                        `name`="ms[GG]", 
                        `title`="Mean Square", 
                        `type`="number", 
                        `visible`="(spherCorr:GG)"),
                    list(
                        `name`="F[GG]", 
                        `title`="F", 
                        `type`="number", 
                        `visible`="(spherCorr:GG)"),
                    list(
                        `name`="p[GG]", 
                        `title`="p", 
                        `type`="number", 
                        `format`="zto,pvalue", 
                        `visible`="(spherCorr:GG)"),
                    list(
                        `name`="eta[GG]", 
                        `title`="\u03B7\u00B2", 
                        `type`="number", 
                        `format`="zto", 
                        `visible`="(effectSize:eta && spherCorr:GG)"),
                    list(
                        `name`="partEta[GG]", 
                        `title`="partial \u03B7\u00B2", 
                        `type`="number", 
                        `format`="zto", 
                        `visible`="(effectSize:partEta && spherCorr:GG)"),
                    list(
                        `name`="omega[GG]", 
                        `title`="\u03C9\u00B2", 
                        `type`="number", 
                        `format`="zto", 
                        `visible`="(effectSize:omega && spherCorr:GG)"),
                    list(
                        `name`="name[HF]", 
                        `title`="", 
                        `type`="text", 
                        `combineBelow`=TRUE, 
                        `visible`="(spherCorr:HF)"),
                    list(
                        `name`="correction[HF]", 
                        `title`="Sphericity Correction", 
                        `type`="text", 
                        `content`="Huynh-Feldt", 
                        `visible`="(spherCorr:HF)"),
                    list(
                        `name`="ss[HF]", 
                        `title`="Sum of Squares", 
                        `type`="number", 
                        `visible`="(spherCorr:HF)"),
                    list(
                        `name`="df[HF]", 
                        `title`="df", 
                        `type`="number", 
                        `visible`="(spherCorr:HF)"),
                    list(
                        `name`="ms[HF]", 
                        `title`="Mean Square", 
                        `type`="number", 
                        `visible`="(spherCorr:HF)"),
                    list(
                        `name`="F[HF]", 
                        `title`="F", 
                        `type`="number", 
                        `visible`="(spherCorr:HF)"),
                    list(
                        `name`="p[HF]", 
                        `title`="p", 
                        `type`="number", 
                        `format`="zto,pvalue", 
                        `visible`="(spherCorr:HF)"),
                    list(
                        `name`="eta[HF]", 
                        `title`="\u03B7\u00B2", 
                        `type`="number", 
                        `format`="zto", 
                        `visible`="(effectSize:eta && spherCorr:HF)"),
                    list(
                        `name`="partEta[HF]", 
                        `title`="partial \u03B7\u00B2", 
                        `type`="number", 
                        `format`="zto", 
                        `visible`="(effectSize:partEta && spherCorr:HF)"),
                    list(
                        `name`="omega[HF]", 
                        `title`="\u03C9\u00B2", 
                        `type`="number", 
                        `format`="zto", 
                        `visible`="(effectSize:omega && spherCorr:HF)"))))
            self$add(jmvcore::Table$new(
                options=options,
                name="bsTable",
                title="Between Subjects Effects",
                clearWith=list(
                    "dependent",
                    "ss",
                    "rmCells",
                    "rmcModelTerms",
                    "bscModelTerms",
                    "bs",
                    "rm",
                    "cov",
                    "rmTerms",
                    "bsTerms"),
                columns=list(
                    list(
                        `name`="name", 
                        `title`="", 
                        `content`=".", 
                        `type`="text"),
                    list(
                        `name`="ss", 
                        `title`="Sum of Squares", 
                        `type`="number"),
                    list(
                        `name`="df", 
                        `title`="df", 
                        `type`="integer"),
                    list(
                        `name`="ms", 
                        `title`="Mean Square", 
                        `type`="number"),
                    list(
                        `name`="F", 
                        `title`="F", 
                        `type`="number"),
                    list(
                        `name`="p", 
                        `title`="p", 
                        `type`="number", 
                        `format`="zto,pvalue"),
                    list(
                        `name`="eta", 
                        `title`="\u03B7\u00B2", 
                        `type`="number", 
                        `format`="zto", 
                        `visible`="(effectSize:eta)"),
                    list(
                        `name`="partEta", 
                        `title`="partial \u03B7\u00B2", 
                        `type`="number", 
                        `format`="zto", 
                        `visible`="(effectSize:partEta)"),
                    list(
                        `name`="omega", 
                        `title`="\u03C9\u00B2", 
                        `type`="number", 
                        `format`="zto", 
                        `visible`="(effectSize:omega)"))))
            self$add(R6::R6Class(
                inherit = jmvcore::Group,
                active = list(
                    spherTable = function() private$.items[["spherTable"]],
                    leveneTable = function() private$.items[["leveneTable"]]),
                private = list(),
                public=list(
                    initialize=function(options) {
                        super$initialize(
                            options=options,
                            name="assump",
                            title="Assumptions")
                        self$add(jmvcore::Table$new(
                            options=options,
                            name="spherTable",
                            title="Tests of Sphericity",
                            visible="(spherTests)",
                            clearWith=list(
                                "dependent",
                                "ss",
                                "rmCells",
                                "rmcModelTerms",
                                "bscModelTerms",
                                "bs",
                                "rm",
                                "cov",
                                "rmTerms",
                                "bsTerms"),
                            columns=list(
                                list(
                                    `name`="name", 
                                    `title`="", 
                                    `type`="text"),
                                list(
                                    `name`="mauch", 
                                    `title`="Mauchly's W", 
                                    `type`="number"),
                                list(
                                    `name`="p", 
                                    `title`="p", 
                                    `type`="number", 
                                    `format`="zto,pvalue"),
                                list(
                                    `name`="gg", 
                                    `title`="Greenhouse-Geisser \u03B5", 
                                    `type`="number"),
                                list(
                                    `name`="hf", 
                                    `title`="Huynh-Feldt \u03B5", 
                                    `type`="number"))))
                        self$add(jmvcore::Table$new(
                            options=options,
                            name="leveneTable",
                            title="Equality of variances test (Levene's)",
                            visible="(leveneTest)",
                            clearWith=list(
                                "bs",
                                "rmCells",
                                "cov"),
                            columns=list(
                                list(
                                    `name`="name", 
                                    `title`="", 
                                    `type`="text"),
                                list(
                                    `name`="F", 
                                    `type`="number"),
                                list(
                                    `name`="df1", 
                                    `type`="integer"),
                                list(
                                    `name`="df2", 
                                    `type`="integer"),
                                list(
                                    `name`="p", 
                                    `type`="number", 
                                    `format`="zto,pvalue"))))}))$new(options=options))
            self$add(jmvcore::Array$new(
                options=options,
                name="contrasts",
                title="Contrasts",
                items=0,
                visible="(contrasts)",
                template=jmvcore::Table$new(
                    options=options,
                    title="Contrasts - $key",
                    rows=0,
                    columns=list(
                        list(
                            `name`="contrast", 
                            `title`="", 
                            `type`="text"),
                        list(
                            `name`="est", 
                            `title`="Estimate", 
                            `type`="number"),
                        list(
                            `name`="se", 
                            `title`="SE", 
                            `type`="number"),
                        list(
                            `name`="t", 
                            `type`="number"),
                        list(
                            `name`="p", 
                            `title`="p", 
                            `type`="number", 
                            `format`="zto,pvalue")))))
            self$add(jmvcore::Array$new(
                options=options,
                name="postHoc",
                title="Post Hoc Tests",
                items="(postHoc)",
                template=jmvcore::Table$new(
                    options=options,
                    title="",
                    columns=list(),
                    clearWith=list(
                        "dependent",
                        "ss",
                        "rmCells",
                        "rmcModelTerms",
                        "bscModelTerms",
                        "bs",
                        "rm",
                        "cov",
                        "rmTerms",
                        "bsTerms"))))
            self$add(jmvcore::Array$new(
                options=options,
                name="emm",
                title="Estimated Marginal Means",
                clearWith=list(
                    "emMeans"),
                template=R6::R6Class(
                    inherit = jmvcore::Group,
                    active = list(
                        emmPlot = function() private$.items[["emmPlot"]],
                        emmTable = function() private$.items[["emmTable"]]),
                    private = list(),
                    public=list(
                        initialize=function(options) {
                            super$initialize(
                                options=options,
                                name="undefined",
                                title="")
                            self$add(jmvcore::Image$new(
                                options=options,
                                name="emmPlot",
                                title="",
                                width=450,
                                height=400,
                                renderFun=".emmPlot",
                                visible="(emmPlots)",
                                clearWith=list(
                                    "ciWidthEmm",
                                    "emmWeights",
                                    "rmCells",
                                    "rmcModelTerms",
                                    "bscModelTerms",
                                    "bs",
                                    "rm",
                                    "cov",
                                    "rmTerms",
                                    "bsTerms",
                                    "emmPlotData",
                                    "emmPlotError",
                                    "depLabel")))
                            self$add(jmvcore::Table$new(
                                options=options,
                                name="emmTable",
                                title="",
                                visible="(emmTables)",
                                columns=list(),
                                clearWith=list(
                                    "ciWidthEmm",
                                    "emmWeights",
                                    "rmCells",
                                    "rmcModelTerms",
                                    "bscModelTerms",
                                    "bs",
                                    "rm",
                                    "cov",
                                    "rmTerms",
                                    "bsTerms")))}))$new(options=options)))}))

anovaRMBase <- if (requireNamespace('jmvcore')) R6::R6Class(
    "anovaRMBase",
    inherit = jmvcore::Analysis,
    public = list(
        initialize = function(options, data=NULL, datasetId="", analysisId="", revision=0) {
            super$initialize(
                package = 'jmv',
                name = 'anovaRM',
                version = c(2,0,0),
                options = options,
                results = anovaRMResults$new(options=options),
                data = data,
                datasetId = datasetId,
                analysisId = analysisId,
                revision = revision,
                pause = NULL,
                completeWhenFilled = TRUE)
        }))

#' Repeated Measures ANOVA
#'
#' The Repeated Measures ANOVA is used to explore the relationship
#' between a continuous dependent variable and one or more categorical
#' explanatory variables, where one or more of the explanatory variables
#' are 'within subjects' (where multiple measurements are from the same
#' subject). Additionally, this analysis allows the inclusion of
#' covariates, allowing for repeated measures ANCOVAs as well.
#' 
#' This analysis requires that the data be in 'wide format', where each
#' row represents a subject (as opposed to long format, where each
#' measurement of the dependent variable is represented as a row).
#' 
#' A non-parametric equivalent of the repeated measures ANOVA also exists;
#' the Friedman test. However, it has the limitation of only being able to
#' test a single factor.
#' 
#'
#' @examples
#' \dontrun{
#' 
#' data('bugs', package = 'jmv')
#'
#' anovaRM(
#'     data = bugs,
#'     rm = list(
#'         list(
#'             label = 'Frightening',
#'             levels = c('Low', 'High'))),
#'     rmCells = list(
#'         list(
#'             measure = 'LDLF',
#'             cell = 'Low'),
#'         list(
#'             measure = 'LDHF',
#'             cell = 'High')),
#'     rmTerms = list(
#'         'Frightening'))
#'
#' #
#' #  REPEATED MEASURES ANOVA
#' #
#' #  Within Subjects Effects
#' #  -----------------------------------------------------------------------
#' #                  Sum of Squares    df    Mean Square    F       p
#' #  -----------------------------------------------------------------------
#' #    Frightening              126     1         126.11    44.2    < .001
#' #    Residual                 257    90           2.85
#' #  -----------------------------------------------------------------------
#' #    Note. Type 3 Sums of Squares
#' #
#' #
#' #
#' #  Between Subjects Effects
#' #  -----------------------------------------------------------------
#' #                Sum of Squares    df    Mean Square    F    p
#' #  -----------------------------------------------------------------
#' #    Residual               954    90           10.6
#' #  -----------------------------------------------------------------
#' #    Note. Type 3 Sums of Squares
#' #
#'}
#' @param data the data as a data frame
#' @param rm a list of lists, where each list describes the \code{label} (as a
#'   string) and the \code{levels} (as vector of strings) of a particular
#'   repeated measures factor
#' @param rmCells a list of lists, where each list decribes a repeated measure
#'   (as a string) from \code{data} defined as \code{measure} and the particular
#'   combination of levels from \code{rm} that it belongs to (as a vector of
#'   strings) defined as \code{cell}
#' @param bs a vector of strings naming the between subjects factors from
#'   \code{data}
#' @param cov a vector of strings naming the covariates from \code{data}.
#'   Variables must be numeric
#' @param effectSize one or more of \code{'eta'}, \code{'partEta'}, or
#'   \code{'omega'}; use eta², partial eta², and omega² effect sizes,
#'   respectively
#' @param depLabel a string (default: 'Dependent') describing the label used
#'   for the dependent variable throughout the analysis
#' @param rmTerms a list of character vectors describing the repeated measures
#'   terms to go into the model
#' @param bsTerms a list of character vectors describing the between subjects
#'   terms to go into the model
#' @param ss \code{'2'} or \code{'3'} (default), the sum of squares to use
#' @param spherTests \code{TRUE} or \code{FALSE} (default), perform sphericity
#'   tests
#' @param spherCorr one or more of \code{'none'} (default), \code{'GG'}, or
#'   \code{}HF\code{}; use no p-value correction, the Greenhouse-Geisser p-value
#'   correction, and the Huynh-Feldt p-value correction for shericity,
#'   respectively
#' @param leveneTest \code{TRUE} or \code{FALSE} (default), test for equality
#'   of variances (i.e., Levene's test)
#' @param contrasts in development
#' @param postHoc a list of character vectors describing the post-hoc tests
#'   that need to be computed
#' @param postHocCorr one or more of \code{'none'}, \code{'tukey'} (default),
#'   \code{'scheffe'}, \code{'bonf'}, or \code{'holm'}; use no, Tukey, Scheffe,
#'   Bonferroni and Holm posthoc corrections, respectively
#' @param emMeans a list of lists specifying the variables for which the
#'   estimated marginal means need to be calculate. Supports up to three
#'   variables per term.
#' @param emmPlots \code{TRUE} (default) or \code{FALSE}, provide estimated
#'   marginal means plots
#' @param emmTables \code{TRUE} or \code{FALSE} (default), provide estimated
#'   marginal means tables
#' @param emmWeights \code{TRUE} (default) or \code{FALSE}, weigh each cell
#'   equally or weigh them according to the cell frequency
#' @param ciWidthEmm a number between 50 and 99.9 (default: 95) specifying the
#'   confidence interval width for the estimated marginal means
#' @param emmPlotData \code{TRUE} or \code{FALSE} (default), plot the data on
#'   top of the marginal means
#' @param emmPlotError \code{'none'}, \code{'ci'} (default), or \code{'se'}.
#'   Use no error bars, use confidence intervals, or use standard errors on the
#'   marginal mean plots, respectively
#' @return A results object containing:
#' \tabular{llllll}{
#'   \code{results$rmTable} \tab \tab \tab \tab \tab a table \cr
#'   \code{results$bsTable} \tab \tab \tab \tab \tab a table \cr
#'   \code{results$assump$spherTable} \tab \tab \tab \tab \tab a table \cr
#'   \code{results$assump$leveneTable} \tab \tab \tab \tab \tab a table \cr
#'   \code{results$contrasts} \tab \tab \tab \tab \tab an array of tables \cr
#'   \code{results$postHoc} \tab \tab \tab \tab \tab an array of tables \cr
#'   \code{results$emm} \tab \tab \tab \tab \tab an array of the estimated marginal means plots + tables \cr
#' }
#'
#' Tables can be converted to data frames with \code{asDF} or \code{\link{as.data.frame}}. For example:
#'
#' \code{results$rmTable$asDF}
#'
#' \code{as.data.frame(results$rmTable)}
#'
#' @export
anovaRM <- function(
    data,
    rm = list(
                list(label="RM Factor 1", levels=list(
                    "Level 1",
                    "Level 2"))),
    rmCells = NULL,
    bs = NULL,
    cov = NULL,
    effectSize = NULL,
    depLabel = "Dependent",
    rmTerms = NULL,
    bsTerms = NULL,
    ss = "3",
    spherTests = FALSE,
    spherCorr = list(
                "none"),
    leveneTest = FALSE,
    contrasts = NULL,
    postHoc = NULL,
    postHocCorr = list(
                "tukey"),
    emMeans = list(
                list()),
    emmPlots = TRUE,
    emmTables = FALSE,
    emmWeights = TRUE,
    ciWidthEmm = 95,
    emmPlotData = FALSE,
    emmPlotError = "ci") {

    if ( ! requireNamespace('jmvcore'))
        stop('anovaRM requires jmvcore to be installed (restart may be required)')

    if ( ! missing(bs)) bs <- jmvcore:::resolveQuo(jmvcore:::enquo(bs))
    if ( ! missing(cov)) cov <- jmvcore:::resolveQuo(jmvcore:::enquo(cov))
    if (missing(data))
        data <- jmvcore:::marshalData(
            parent.frame(),
            `if`( ! missing(bs), bs, NULL),
            `if`( ! missing(cov), cov, NULL))

    for (v in bs) if (v %in% names(data)) data[[v]] <- as.factor(data[[v]])
    if (inherits(rmTerms, 'formula')) rmTerms <- jmvcore:::decomposeFormula(rmTerms)
    if (inherits(bsTerms, 'formula')) bsTerms <- jmvcore:::decomposeFormula(bsTerms)
    if (inherits(emMeans, 'formula')) emMeans <- jmvcore:::decomposeFormula(emMeans)

    options <- anovaRMOptions$new(
        rm = rm,
        rmCells = rmCells,
        bs = bs,
        cov = cov,
        effectSize = effectSize,
        depLabel = depLabel,
        rmTerms = rmTerms,
        bsTerms = bsTerms,
        ss = ss,
        spherTests = spherTests,
        spherCorr = spherCorr,
        leveneTest = leveneTest,
        contrasts = contrasts,
        postHoc = postHoc,
        postHocCorr = postHocCorr,
        emMeans = emMeans,
        emmPlots = emmPlots,
        emmTables = emmTables,
        emmWeights = emmWeights,
        ciWidthEmm = ciWidthEmm,
        emmPlotData = emmPlotData,
        emmPlotError = emmPlotError)

    results <- anovaRMResults$new(
        options = options)

    analysis <- anovaRMClass$new(
        options = options,
        data = data)

    analysis$run()

    analysis$results
}
