
# This file is automatically generated, you probably don't want to edit this

#' @importFrom jmvcore Options
#' @importFrom R6 R6Class
pcaOptions <- R6::R6Class(
    "pcaOptions",
    inherit = jmvcore::Options,
    public = list(
        initialize = function(
            vars = NULL,
            nFactorMethod = "parallel",
            nFactors = 1,
            minEigen = 1,
            rotation = "varimax",
            hideLoadings = 0.3,
            screePlot = FALSE,
            eigenValues = FALSE,
            factorCor = FALSE,
            factorSummary = FALSE,
            kmoTest = FALSE,
            bartlettTest = FALSE, ...) {

            super$initialize(
                package='jmv',
                name='pca',
                requiresData=TRUE,
                ...)
        
            private$..vars <- jmvcore::OptionVariables$new(
                "vars",
                vars,
                suggested=list(
                    "ordinal",
                    "continuous"),
                permitted=list(
                    "continuous",
                    "nominal",
                    "ordinal"),
                rejectInf=FALSE)
            private$..nFactorMethod <- jmvcore::OptionList$new(
                "nFactorMethod",
                nFactorMethod,
                options=list(
                    "parallel",
                    "eigen",
                    "fixed"),
                default="parallel")
            private$..nFactors <- jmvcore::OptionInteger$new(
                "nFactors",
                nFactors,
                min=1,
                default=1)
            private$..minEigen <- jmvcore::OptionNumber$new(
                "minEigen",
                minEigen,
                default=1)
            private$..rotation <- jmvcore::OptionList$new(
                "rotation",
                rotation,
                options=list(
                    "none",
                    "varimax",
                    "quartimax",
                    "promax",
                    "oblimin",
                    "simplimax"),
                default="varimax")
            private$..hideLoadings <- jmvcore::OptionNumber$new(
                "hideLoadings",
                hideLoadings,
                default=0.3)
            private$..screePlot <- jmvcore::OptionBool$new(
                "screePlot",
                screePlot,
                default=FALSE)
            private$..eigenValues <- jmvcore::OptionBool$new(
                "eigenValues",
                eigenValues,
                default=FALSE)
            private$..factorCor <- jmvcore::OptionBool$new(
                "factorCor",
                factorCor,
                default=FALSE)
            private$..factorSummary <- jmvcore::OptionBool$new(
                "factorSummary",
                factorSummary,
                default=FALSE)
            private$..kmoTest <- jmvcore::OptionBool$new(
                "kmoTest",
                kmoTest,
                default=FALSE)
            private$..bartlettTest <- jmvcore::OptionBool$new(
                "bartlettTest",
                bartlettTest,
                default=FALSE)
        
            self$.addOption(private$..vars)
            self$.addOption(private$..nFactorMethod)
            self$.addOption(private$..nFactors)
            self$.addOption(private$..minEigen)
            self$.addOption(private$..rotation)
            self$.addOption(private$..hideLoadings)
            self$.addOption(private$..screePlot)
            self$.addOption(private$..eigenValues)
            self$.addOption(private$..factorCor)
            self$.addOption(private$..factorSummary)
            self$.addOption(private$..kmoTest)
            self$.addOption(private$..bartlettTest)
        }),
    active = list(
        vars = function() private$..vars$value,
        nFactorMethod = function() private$..nFactorMethod$value,
        nFactors = function() private$..nFactors$value,
        minEigen = function() private$..minEigen$value,
        rotation = function() private$..rotation$value,
        hideLoadings = function() private$..hideLoadings$value,
        screePlot = function() private$..screePlot$value,
        eigenValues = function() private$..eigenValues$value,
        factorCor = function() private$..factorCor$value,
        factorSummary = function() private$..factorSummary$value,
        kmoTest = function() private$..kmoTest$value,
        bartlettTest = function() private$..bartlettTest$value),
    private = list(
        ..vars = NA,
        ..nFactorMethod = NA,
        ..nFactors = NA,
        ..minEigen = NA,
        ..rotation = NA,
        ..hideLoadings = NA,
        ..screePlot = NA,
        ..eigenValues = NA,
        ..factorCor = NA,
        ..factorSummary = NA,
        ..kmoTest = NA,
        ..bartlettTest = NA)
)

#' @import jmvcore
#' @importFrom R6 R6Class
pcaResults <- R6::R6Class(
    inherit = jmvcore::Group,
    active = list(
        loadings = function() private$..loadings,
        factorStats = function() private$..factorStats,
        modelFit = function() private$..modelFit,
        assump = function() private$..assump,
        eigen = function() private$..eigen),
    private = list(
        ..loadings = NA,
        ..factorStats = NA,
        ..modelFit = NA,
        ..assump = NA,
        ..eigen = NA),
    public=list(
        initialize=function(options) {
            super$initialize(options=options, name="", title="Principal Component Analysis")
            private$..loadings <- jmvcore::Table$new(
                options=options,
                name="loadings",
                title="Component Loadings",
                rows="(vars)",
                clearWith=list(
                    "vars",
                    "nFactorMethod",
                    "nFactors",
                    "hideLoadings",
                    "rotation"),
                columns=list(
                    list(`name`="name", `title`="", `type`="text", `content`="($key)"),
                    list(`name`="pc1", `title`="1", `type`="number", `superTitle`="Component"),
                    list(`name`="uniq", `title`="Uniqueness", `type`="number")))
            private$..factorStats <- R6::R6Class(
                inherit = jmvcore::Group,
                active = list(
                    factorSummary = function() private$..factorSummary,
                    factorCor = function() private$..factorCor),
                private = list(
                    ..factorSummary = NA,
                    ..factorCor = NA),
                public=list(
                    initialize=function(options) {
                        super$initialize(options=options, name="factorStats", title="Component Statistics")
                        private$..factorSummary <- jmvcore::Table$new(
                            options=options,
                            name="factorSummary",
                            title="Summary",
                            visible="(factorSummary)",
                            clearWith=list(
                                "vars",
                                "nFactorMethod",
                                "nFactors",
                                "rotation"),
                            columns=list(
                                list(`name`="comp", `title`="Component", `type`="text"),
                                list(`name`="loadings", `title`="SS Loadings", `type`="number"),
                                list(`name`="varProp", `title`="% of Variance", `type`="number"),
                                list(`name`="varCum", `title`="Cumulative %", `type`="number")))
                        private$..factorCor <- jmvcore::Table$new(
                            options=options,
                            name="factorCor",
                            title="Correlation Matrix",
                            visible="(factorCor)",
                            clearWith=list(
                                "vars",
                                "nFactorMethod",
                                "nFactors",
                                "hideLoadings",
                                "rotation"),
                            columns=list(
                                list(`name`="comp", `title`="", `type`="text", `format`="narrow"),
                                list(`name`="pc1", `title`="1", `type`="number")))
                        self$add(private$..factorSummary)
                        self$add(private$..factorCor)}))$new(options=options)
            private$..modelFit <- R6::R6Class(
                inherit = jmvcore::Group,
                active = list(
                    fit = function() private$..fit),
                private = list(
                    ..fit = NA),
                public=list(
                    initialize=function(options) {
                        super$initialize(options=options, name="modelFit", title="Model Fit")
                        private$..fit <- jmvcore::Table$new(
                            options=options,
                            name="fit",
                            title="Model Fit Measures",
                            rows=1,
                            visible=FALSE,
                            clearWith=list(
                                "vars",
                                "nFactorMethod",
                                "nFactors",
                                "rotation"),
                            columns=list(
                                list(`name`="tli", `title`="TLI", `type`="number"),
                                list(`name`="rmsea", `title`="RMSEA", `type`="number"),
                                list(`name`="bic", `title`="BIC", `type`="number"),
                                list(`name`="chi", `title`="\u03C7\u00B2", `type`="number", `superTitle`="Model Test"),
                                list(`name`="df", `title`="df", `type`="integer", `superTitle`="Model Test"),
                                list(`name`="p", `title`="p", `type`="number", `format`="zto,pvalue", `superTitle`="Model Test")))
                        self$add(private$..fit)}))$new(options=options)
            private$..assump <- R6::R6Class(
                inherit = jmvcore::Group,
                active = list(
                    bartlett = function() private$..bartlett,
                    kmo = function() private$..kmo),
                private = list(
                    ..bartlett = NA,
                    ..kmo = NA),
                public=list(
                    initialize=function(options) {
                        super$initialize(options=options, name="assump", title="Assumption Checks")
                        private$..bartlett <- jmvcore::Table$new(
                            options=options,
                            name="bartlett",
                            title="Bartlett's Test of Sphericity",
                            visible="(bartlettTest)",
                            rows=1,
                            clearWith=list(
                                "vars"),
                            columns=list(
                                list(`name`="chi", `title`="\u03C7\u00B2", `type`="number"),
                                list(`name`="df", `title`="df", `type`="integer"),
                                list(`name`="p", `title`="p", `type`="number", `format`="zto,pvalue")))
                        private$..kmo <- jmvcore::Table$new(
                            options=options,
                            name="kmo",
                            title="KMO Measure of Sampling Adequacy",
                            visible="(kmoTest)",
                            clearWith=list(
                                "vars"),
                            columns=list(
                                list(`name`="name", `title`="", `type`="text"),
                                list(`name`="msa", `title`="MSA", `type`="number", `format`="zto")))
                        self$add(private$..bartlett)
                        self$add(private$..kmo)}))$new(options=options)
            private$..eigen <- R6::R6Class(
                inherit = jmvcore::Group,
                active = list(
                    initEigen = function() private$..initEigen,
                    screePlot = function() private$..screePlot),
                private = list(
                    ..initEigen = NA,
                    ..screePlot = NA),
                public=list(
                    initialize=function(options) {
                        super$initialize(options=options, name="eigen", title="Eigenvalues")
                        private$..initEigen <- jmvcore::Table$new(
                            options=options,
                            name="initEigen",
                            title="Initial Eigenvalues",
                            visible="(eigenValues)",
                            clearWith=list(
                                "vars"),
                            columns=list(
                                list(`name`="comp", `title`="Component", `type`="text"),
                                list(`name`="eigen", `title`="Eigenvalue", `type`="number"),
                                list(`name`="varProp", `title`="% of Variance", `type`="number"),
                                list(`name`="varCum", `title`="Cumulative %", `type`="number")))
                        private$..screePlot <- jmvcore::Image$new(
                            options=options,
                            name="screePlot",
                            title="Scree Plot",
                            visible="(screePlot)",
                            width=500,
                            height=300,
                            renderFun=".screePlot",
                            clearWith=list(
                                "vars",
                                "screePlot",
                                "nFactorMethod",
                                "minEigen"))
                        self$add(private$..initEigen)
                        self$add(private$..screePlot)}))$new(options=options)
            self$add(private$..loadings)
            self$add(private$..factorStats)
            self$add(private$..modelFit)
            self$add(private$..assump)
            self$add(private$..eigen)}))

#' @importFrom jmvcore Analysis
#' @importFrom R6 R6Class
pcaBase <- R6::R6Class(
    "pcaBase",
    inherit = jmvcore::Analysis,
    public = list(
        initialize = function(options, data=NULL, datasetId="", analysisId="", revision=0) {
            super$initialize(
                package = 'jmv',
                name = 'pca',
                version = c(1,0,0),
                options = options,
                results = pcaResults$new(options=options),
                data = data,
                datasetId = datasetId,
                analysisId = analysisId,
                revision = revision,
                pause = NULL,
                completeWhenFilled = FALSE)
        }))

#' Principal Component Analysis
#'
#' Principal Component Analysis
#'
#' @examples
#' data('iris')
#' dat <- as.data.frame(iris)
#' 
#' jmv::pca(data = dat, vars = c('Sepal.Length', 'Sepal.Width', 'Petal.Length', 'Petal.Width'))
#' 
#' #
#' #  Component Loadings
#' #  ----------------------------------------
#' #                    1         Uniqueness
#' #  ----------------------------------------
#' #    Sepal.Length     0.890        0.2076
#' #    Sepal.Width     -0.460        0.7883
#' #    Petal.Length     0.992        0.0168
#' #    Petal.Width      0.965        0.0688
#' #  ----------------------------------------
#' #    Note. 'varimax' rotation was used
#' #
#' #
#' 
#' @param data .
#' @param vars a vector of strings naming the variables of interest in 
#'   \code{data}
#' @param nFactorMethod \code{'parallel'} (default), \code{'eigen'} or 
#'   \code{'fixed'}, the way to determine the number of factors 
#' @param nFactors an integer (default: 1), the number of components in the 
#'   model 
#' @param minEigen a number (default: 1), the minimal eigenvalue for a 
#'   component to be included in the model 
#' @param rotation \code{'none'}, \code{'varimax'} (default), 
#'   \code{'quartimax'}, \code{'promax'}, \code{'oblimin'}, or 
#'   \code{'simplimax'}, the rotation to use in estimation 
#' @param hideLoadings a number (default: 0.3), hide loadings below this value 
#' @param screePlot \code{TRUE} or \code{FALSE} (default), show scree plot 
#' @param eigenValues \code{TRUE} or \code{FALSE} (default), show eigenvalue 
#'   table 
#' @param factorCor \code{TRUE} or \code{FALSE} (default), show factor 
#'   correlations 
#' @param factorSummary \code{TRUE} or \code{FALSE} (default), show factor 
#'   summary 
#' @param kmoTest \code{TRUE} or \code{FALSE} (default), show 
#'   Kaiser-Meyer-Olkin (KMO) measure of sampling adequacy (MSA) results 
#' @param bartlettTest \code{TRUE} or \code{FALSE} (default), show Bartlett's 
#'   test of sphericity results 
#' @export
pca <- function(
    data,
    vars,
    nFactorMethod = "parallel",
    nFactors = 1,
    minEigen = 1,
    rotation = "varimax",
    hideLoadings = 0.3,
    screePlot = FALSE,
    eigenValues = FALSE,
    factorCor = FALSE,
    factorSummary = FALSE,
    kmoTest = FALSE,
    bartlettTest = FALSE) {

    options <- pcaOptions$new(
        vars = vars,
        nFactorMethod = nFactorMethod,
        nFactors = nFactors,
        minEigen = minEigen,
        rotation = rotation,
        hideLoadings = hideLoadings,
        screePlot = screePlot,
        eigenValues = eigenValues,
        factorCor = factorCor,
        factorSummary = factorSummary,
        kmoTest = kmoTest,
        bartlettTest = bartlettTest)

    results <- pcaResults$new(
        options = options)

    analysis <- pcaClass$new(
        options = options,
        data = data)

    analysis$run()

    analysis$results
}
