
# This file is automatically generated, you probably don't want to edit this

#' @importFrom jmvcore Options
#' @importFrom R6 R6Class
ttestISOptions <- R6::R6Class(
    "ttestISOptions",
    inherit = jmvcore::Options,
    public = list(
        initialize = function(
            vars = NULL,
            group = NULL,
            students = TRUE,
            bf = FALSE,
            bfPrior = 0.707,
            welchs = FALSE,
            mann = FALSE,
            hypothesis = "different",
            norm = FALSE,
            eqv = FALSE,
            meanDiff = FALSE,
            effectSize = FALSE,
            ci = FALSE,
            ciWidth = 95,
            desc = FALSE,
            plots = FALSE,
            miss = "perAnalysis", ...) {

            super$initialize(
                package='jmv',
                name='ttestIS',
                requiresData=TRUE,
                ...)
        
            private$..vars <- jmvcore::OptionVariables$new(
                "vars",
                vars,
                suggested=list(
                    "continuous"),
                permitted=list(
                    "continuous",
                    "nominal",
                    "ordinal"),
                rejectInf=FALSE)
            private$..group <- jmvcore::OptionVariable$new(
                "group",
                group,
                suggested=list(
                    "nominal",
                    "ordinal"))
            private$..students <- jmvcore::OptionBool$new(
                "students",
                students,
                default=TRUE)
            private$..bf <- jmvcore::OptionBool$new(
                "bf",
                bf,
                default=FALSE)
            private$..bfPrior <- jmvcore::OptionNumber$new(
                "bfPrior",
                bfPrior,
                default=0.707,
                min=0.5,
                max=2)
            private$..welchs <- jmvcore::OptionBool$new(
                "welchs",
                welchs,
                default=FALSE)
            private$..mann <- jmvcore::OptionBool$new(
                "mann",
                mann,
                default=FALSE)
            private$..hypothesis <- jmvcore::OptionList$new(
                "hypothesis",
                hypothesis,
                options=list(
                    "different",
                    "oneGreater",
                    "twoGreater"),
                default="different")
            private$..norm <- jmvcore::OptionBool$new(
                "norm",
                norm,
                default=FALSE)
            private$..eqv <- jmvcore::OptionBool$new(
                "eqv",
                eqv,
                default=FALSE)
            private$..meanDiff <- jmvcore::OptionBool$new(
                "meanDiff",
                meanDiff,
                default=FALSE)
            private$..effectSize <- jmvcore::OptionBool$new(
                "effectSize",
                effectSize,
                default=FALSE)
            private$..ci <- jmvcore::OptionBool$new(
                "ci",
                ci,
                default=FALSE)
            private$..ciWidth <- jmvcore::OptionNumber$new(
                "ciWidth",
                ciWidth,
                min=50,
                max=99.9,
                default=95)
            private$..desc <- jmvcore::OptionBool$new(
                "desc",
                desc,
                default=FALSE)
            private$..plots <- jmvcore::OptionBool$new(
                "plots",
                plots,
                default=FALSE)
            private$..miss <- jmvcore::OptionList$new(
                "miss",
                miss,
                options=list(
                    "perAnalysis",
                    "listwise"),
                default="perAnalysis")
        
            self$.addOption(private$..vars)
            self$.addOption(private$..group)
            self$.addOption(private$..students)
            self$.addOption(private$..bf)
            self$.addOption(private$..bfPrior)
            self$.addOption(private$..welchs)
            self$.addOption(private$..mann)
            self$.addOption(private$..hypothesis)
            self$.addOption(private$..norm)
            self$.addOption(private$..eqv)
            self$.addOption(private$..meanDiff)
            self$.addOption(private$..effectSize)
            self$.addOption(private$..ci)
            self$.addOption(private$..ciWidth)
            self$.addOption(private$..desc)
            self$.addOption(private$..plots)
            self$.addOption(private$..miss)
        }),
    active = list(
        vars = function() private$..vars$value,
        group = function() private$..group$value,
        students = function() private$..students$value,
        bf = function() private$..bf$value,
        bfPrior = function() private$..bfPrior$value,
        welchs = function() private$..welchs$value,
        mann = function() private$..mann$value,
        hypothesis = function() private$..hypothesis$value,
        norm = function() private$..norm$value,
        eqv = function() private$..eqv$value,
        meanDiff = function() private$..meanDiff$value,
        effectSize = function() private$..effectSize$value,
        ci = function() private$..ci$value,
        ciWidth = function() private$..ciWidth$value,
        desc = function() private$..desc$value,
        plots = function() private$..plots$value,
        miss = function() private$..miss$value),
    private = list(
        ..vars = NA,
        ..group = NA,
        ..students = NA,
        ..bf = NA,
        ..bfPrior = NA,
        ..welchs = NA,
        ..mann = NA,
        ..hypothesis = NA,
        ..norm = NA,
        ..eqv = NA,
        ..meanDiff = NA,
        ..effectSize = NA,
        ..ci = NA,
        ..ciWidth = NA,
        ..desc = NA,
        ..plots = NA,
        ..miss = NA)
)

#' @import jmvcore
#' @importFrom R6 R6Class
ttestISResults <- R6::R6Class(
    inherit = jmvcore::Group,
    active = list(
        ttest = function() private$..ttest,
        assum = function() private$..assum,
        desc = function() private$..desc,
        plots = function() private$..plots),
    private = list(
        ..ttest = NA,
        ..assum = NA,
        ..desc = NA,
        ..plots = NA),
    public=list(
        initialize=function(options) {
            super$initialize(options=options, name="", title="Independent Samples T-Test")
            private$..ttest <- jmvcore::Table$new(
                options=options,
                name="ttest",
                title="Independent Samples T-Test",
                rows="(vars)",
                clearWith=list(
                    "group",
                    "hypothesis",
                    "ciWidth",
                    "miss"),
                columns=list(
                    list(`name`="var[stud]", `title`="", `content`="($key)", `type`="text", `combineBelow`=TRUE, `visible`="(students)"),
                    list(`name`="name[stud]", `title`="", `type`="text", `content`="Student's t", `visible`="(students)"),
                    list(`name`="stat[stud]", `title`="statistic", `type`="number", `visible`="(students)"),
                    list(`name`="err[stud]", `title`="error %", `type`="number", `visible`="(students && bf)", `content`=""),
                    list(`name`="df[stud]", `title`="df", `type`="number", `visible`="(students)"),
                    list(`name`="p[stud]", `title`="p", `type`="number", `format`="zto,pvalue", `visible`="(students)"),
                    list(`name`="md[stud]", `title`="Mean difference", `type`="number", `visible`="(meanDiff && students)"),
                    list(`name`="sed[stud]", `title`="SE difference", `type`="number", `visible`="(meanDiff && students)"),
                    list(`name`="es[stud]", `title`="Cohen's d", `type`="number", `visible`="(effectSize && students)"),
                    list(`name`="cil[stud]", `title`="Lower", `type`="number", `visible`="(ci && students)"),
                    list(`name`="ciu[stud]", `title`="Upper", `type`="number", `visible`="(ci && students)"),
                    list(`name`="var[bf]", `title`="", `content`="($key)", `type`="text", `combineBelow`=TRUE, `visible`="(bf)"),
                    list(`name`="name[bf]", `title`="", `type`="text", `content`="Bayes factor\u2081\u2080", `visible`="(bf)"),
                    list(`name`="stat[bf]", `title`="statistic", `type`="number", `visible`="(bf)"),
                    list(`name`="err[bf]", `title`="\u00B1%", `type`="number", `visible`="(bf)"),
                    list(`name`="df[bf]", `title`="df", `type`="number", `visible`="(bf)", `content`=""),
                    list(`name`="p[bf]", `title`="p", `type`="number", `format`="zto,pvalue", `visible`="(bf)", `content`=""),
                    list(`name`="md[bf]", `title`="Mean difference", `type`="number", `visible`="(meanDiff && bf)", `content`=""),
                    list(`name`="sed[bf]", `title`="SE difference", `type`="number", `visible`="(meanDiff && bf)", `content`=""),
                    list(`name`="es[bf]", `title`="Cohen's d", `type`="number", `visible`="(effectSize && bf)", `content`=""),
                    list(`name`="cil[bf]", `title`="Lower", `type`="number", `visible`="(ci && bf)", `content`=""),
                    list(`name`="ciu[bf]", `title`="Upper", `type`="number", `visible`="(ci && bf)", `content`=""),
                    list(`name`="var[welc]", `title`="", `content`="($key)", `type`="text", `combineBelow`=TRUE, `visible`="(welchs)"),
                    list(`name`="name[welc]", `title`="", `type`="text", `content`="Welch's t", `visible`="(welchs)"),
                    list(`name`="stat[welc]", `title`="statistic", `visible`="(welchs)"),
                    list(`name`="err[welc]", `title`="\u00B1%", `type`="number", `visible`="(welchs && bf)", `content`=""),
                    list(`name`="df[welc]", `title`="df", `type`="number", `visible`="(welchs)"),
                    list(`name`="p[welc]", `title`="p", `type`="number", `format`="zto,pvalue", `visible`="(welchs)"),
                    list(`name`="md[welc]", `title`="Mean difference", `type`="number", `visible`="(meanDiff && welchs)"),
                    list(`name`="sed[welc]", `title`="SE difference", `type`="number", `visible`="(meanDiff && welchs)"),
                    list(`name`="es[welc]", `title`="Cohen's d", `type`="number", `visible`="(effectSize && welchs)"),
                    list(`name`="cil[welc]", `title`="Lower", `type`="number", `visible`="(ci && welchs)"),
                    list(`name`="ciu[welc]", `title`="Upper", `type`="number", `visible`="(ci && welchs)"),
                    list(`name`="var[mann]", `title`="", `content`="($key)", `type`="text", `combineBelow`=TRUE, `visible`="(mann)"),
                    list(`name`="name[mann]", `title`="", `type`="text", `content`="Mann-Whitney U", `visible`="(mann)"),
                    list(`name`="stat[mann]", `title`="statistic", `content`=".", `visible`="(mann)"),
                    list(`name`="err[mann]", `title`="\u00B1%", `type`="number", `visible`="(mann && bf)", `content`=""),
                    list(`name`="p[mann]", `title`="p", `type`="number", `format`="zto,pvalue", `visible`="(mann)"),
                    list(`name`="md[mann]", `title`="Mean difference", `type`="number", `visible`="(meanDiff && mann)"),
                    list(`name`="sed[mann]", `title`="SE difference", `type`="number", `visible`="(meanDiff && mann)"),
                    list(`name`="es[mann]", `title`="Cohen's d", `type`="number", `visible`="(effectSize && mann)"),
                    list(`name`="cil[mann]", `title`="Lower", `type`="number", `visible`="(ci && mann)"),
                    list(`name`="ciu[mann]", `title`="Upper", `type`="number", `visible`="(ci && mann)")))
            private$..assum <- R6::R6Class(
                inherit = jmvcore::Group,
                active = list(
                    norm = function() private$..norm,
                    eqv = function() private$..eqv),
                private = list(
                    ..norm = NA,
                    ..eqv = NA),
                public=list(
                    initialize=function(options) {
                        super$initialize(options=options, name="assum", title="Assumptions")
                        private$..norm <- jmvcore::Table$new(
                            options=options,
                            name="norm",
                            title="Test of Normality (Shapiro-Wilk)",
                            visible="(norm)",
                            rows="(vars)",
                            clearWith=list(
                                "miss",
                                "group"),
                            notes=list(`p`="A low p-value suggests a violation of the assumption of normality"),
                            columns=list(
                                list(`name`="name", `title`="", `content`="($key)", `type`="text"),
                                list(`name`="w", `title`="W", `type`="number"),
                                list(`name`="p", `title`="p", `type`="number", `format`="zto,pvalue")))
                        private$..eqv <- jmvcore::Table$new(
                            options=options,
                            name="eqv",
                            title="Test of Equality of Variances (Levene's)",
                            visible="(eqv)",
                            rows="(vars)",
                            clearWith=list(
                                "group",
                                "miss"),
                            notes=list(`p`="A low p-value suggests a violation of the assumption of equal variances"),
                            columns=list(
                                list(`name`="name", `title`="", `content`="($key)", `type`="text"),
                                list(`name`="f", `title`="F", `type`="number"),
                                list(`name`="df", `type`="number"),
                                list(`name`="p", `type`="number", `format`="zto,pvalue")))
                        self$add(private$..norm)
                        self$add(private$..eqv)}))$new(options=options)
            private$..desc <- jmvcore::Table$new(
                options=options,
                name="desc",
                title="Group Descriptives",
                visible="(desc)",
                rows="(vars)",
                clearWith=list(
                    "group",
                    "miss"),
                columns=list(
                    list(`name`="dep", `title`="", `content`="($key)", `type`="text"),
                    list(`name`="group[1]", `title`="Group", `type`="text"),
                    list(`name`="num[1]", `title`="N", `type`="integer"),
                    list(`name`="mean[1]", `title`="Mean", `type`="number"),
                    list(`name`="med[1]", `title`="Median", `type`="number"),
                    list(`name`="sd[1]", `title`="SD", `type`="number"),
                    list(`name`="se[1]", `title`="SE", `type`="number"),
                    list(`name`="group[2]", `title`="Group", `type`="text"),
                    list(`name`="num[2]", `title`="N", `type`="integer"),
                    list(`name`="mean[2]", `title`="Mean", `type`="number"),
                    list(`name`="med[2]", `title`="Median", `type`="number"),
                    list(`name`="sd[2]", `title`="SD", `type`="number"),
                    list(`name`="se[2]", `title`="SE", `type`="number")))
            private$..plots <- jmvcore::Array$new(
                options=options,
                name="plots",
                title="Plots",
                visible="(plots)",
                items="(vars)",
                template=jmvcore::Image$new(
                    options=options,
                    title="$key",
                    renderFun=".plot",
                    clearWith=list(
                        "group",
                        "miss")))
            self$add(private$..ttest)
            self$add(private$..assum)
            self$add(private$..desc)
            self$add(private$..plots)}))

#' @importFrom jmvcore Analysis
#' @importFrom R6 R6Class
ttestISBase <- R6::R6Class(
    "ttestISBase",
    inherit = jmvcore::Analysis,
    public = list(
        initialize = function(options, data=NULL, datasetId="", analysisId="", revision=0) {
            super$initialize(
                package = 'jmv',
                name = 'ttestIS',
                version = c(1,0,0),
                options = options,
                results = ttestISResults$new(options=options),
                data = data,
                datasetId = datasetId,
                analysisId = analysisId,
                revision = revision,
                pause = NULL)
        }))

#' Independent Samples T-Test
#'
#' 
#'
#' @examples
#' \dontrun{
#' ttestIS(data, vars='len', group='supp')
#' }
#' @param data the data as a data frame
#' @param vars a vector of strings naming the dependent variables
#' @param group a string naming the grouping variable, must have 2 levels
#' @param students \code{TRUE} (default) or \code{FALSE}, perform Student's 
#'   t-tests 
#' @param bf \code{TRUE} or \code{FALSE} (default), provide Bayes factors 
#' @param bfPrior a number between 0.5 and 2 (default 0.707), the prior width 
#'   to use in calculating Bayes factors 
#' @param welchs \code{TRUE} or \code{FALSE} (default), perform Welch's 
#'   t-tests 
#' @param mann \code{TRUE} or \code{FALSE} (default), perform Mann-Whitney U 
#'   tests 
#' @param hypothesis \code{'different'} (default), \code{'oneGreater'} or 
#'   \code{'twoGreater'}, the alternative hypothesis; group 1 different to group 
#'   2, group 1 greater than group 2, and group 2 greater than group 1 
#'   respectively 
#' @param norm \code{TRUE} or \code{FALSE} (default), perform Shapiro-Wilk 
#'   test of normality 
#' @param eqv \code{TRUE} or \code{FALSE} (default), perform Levene's test for 
#'   equality of variances 
#' @param meanDiff \code{TRUE} or \code{FALSE} (default), provide means and 
#'   standard errors 
#' @param effectSize \code{TRUE} or \code{FALSE} (default), provide effect 
#'   sizes 
#' @param ci \code{TRUE} or \code{FALSE} (default), provide confidence 
#'   intervals 
#' @param ciWidth a number between 50 and 99.9 (default: 95), the width of 
#'   confidence intervals 
#' @param desc \code{TRUE} or \code{FALSE} (default), provide descriptive 
#'   statistics 
#' @param plots \code{TRUE} or \code{FALSE} (default), provide descriptive 
#'   plots 
#' @param miss \code{'perAnalysis'} or \code{'listwise'}, how to handle 
#'   missing values; \code{'perAnalysis'} excludes missing values for individual 
#'   dependent variables, \code{'listwise'} excludes a row from all analyses if 
#'   one of its entries is missing. 
#' @export
ttestIS <- function(
    data,
    vars,
    group,
    students = TRUE,
    bf = FALSE,
    bfPrior = 0.707,
    welchs = FALSE,
    mann = FALSE,
    hypothesis = "different",
    norm = FALSE,
    eqv = FALSE,
    meanDiff = FALSE,
    effectSize = FALSE,
    ci = FALSE,
    ciWidth = 95,
    desc = FALSE,
    plots = FALSE,
    miss = "perAnalysis") {

    options <- ttestISOptions$new(
        vars = vars,
        group = group,
        students = students,
        bf = bf,
        bfPrior = bfPrior,
        welchs = welchs,
        mann = mann,
        hypothesis = hypothesis,
        norm = norm,
        eqv = eqv,
        meanDiff = meanDiff,
        effectSize = effectSize,
        ci = ci,
        ciWidth = ciWidth,
        desc = desc,
        plots = plots,
        miss = miss)

    results <- ttestISResults$new(
        options = options)

    analysis <- ttestISClass$new(
        options = options,
        data = data)

    analysis$run()
    analysis$render()

    analysis
}
