% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/jmetrik.R
\name{jmetrikWrite}
\alias{jmetrikWrite}
\title{Writes a file in *.jmetrik format.}
\usage{
jmetrikWrite(x, fileName, scoring = NULL, codes = NULL, labels = NULL)
}
\arguments{
\item{x}{A data frame}

\item{fileName}{The complete path and name of the file to be written. The file siffix must be .jmetrik.}

\item{scoring}{An optional character vector of item scoring. Each element in this vector has two sets
 of parentheses. The first set contains the response option codes. The second set contains the scores
 assigned to each option. There is a correspondence between each set of parentheses such that the first
 element in the code list corresponds to the first element in the score list.}

\item{codes}{An optional character vector of special codes. Each element in this vector has two sets
 of parentheses. The first set contains the missing data, omitted, and not reached codes.
 The second set contains the scores assigned to each code. There is a correspondence between
 each set of parentheses such that the first element in the code list corresponds to the first
 element in the score list.}

\item{labels}{An optional character vector of variable labels}
}
\description{
'jMetrik' is a stand alone program written in Java. It defines a file format that is just a plain text
file with a header and comma delimited values. The header contains information about the variables
in the file. There is one row in the header for each variable in the file. The header also includes
meta information about the data such as the number of rows. This function will create a *.jmetrik
file from a data frame. The jMetrik program and other informaiton is available at
\url{http://www.Itemanalysis.com}
}
\examples{
\dontrun{

#Create some data
id<-100+seq(1:10)
x<-sample(c("A", "B", "C", "D"), 10, replace=TRUE)
y<-sample(c("A", "B", "C", "D"), 10, replace=TRUE)
z<-sample(c(0,1,2,3), 10, replace=TRUE)
sc<-rnorm(10)
exdata<-as.data.frame(cbind(id, x, y, z, sc))
names(exdata)<-c("id", "item1", "item2", "item3", "score")

#A is the correct answer
aOK<- "(A,B,C,D)(1,0,0,0)"

#B is the correct answer
bOK<-"(A,B,C,D)(0,1,0,0)"

#polytomous item scoring
poly<-"(0,1,2,3)(0,1,2,3)"

#Special data codes e.g. missing and not reached responses
#These can be unique to each item or the same. Here they
#are the same.
datCodes<-"(NA,OM,NR)(0,0,0)"

#Create scoring, special data codes, and labels
scoring<-c("", aOK, bOK, poly, "")
codes<-c("", rep(datCodes, 3), "")
labels<-c("ID variable", "Test item 1", "Test item 2", "Test item 3", "Test score")

#write the file
jmetrikWrite(x=exdata, fileName="./test-write.jmetrik",
            codes=codes, scoring=scoring, labels=labels)

}
}
\author{
J. Patrick Meyer \email{support@itemanalysis.com}
}

