% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jma_collect.R
\name{jma_collect}
\alias{jma_collect}
\title{Collect JMA Historical Weather Data}
\usage{
jma_collect(
  item = NULL,
  block_no,
  year,
  month,
  day,
  cache = TRUE,
  pack = TRUE,
  quiet = FALSE
)
}
\arguments{
\item{item}{Type of weather data to be acquired. Mainly specifies
the interval between records (e.g. \code{daily} or \code{hourly}).
See NOTE for details.}

\item{block_no}{Block number of the location to be observed. It is assumed that
block_no is input as a string consisting of a 4- or 5-digit number. If a
numeric value is specified, it is processed as a string.}

\item{year}{select year}

\item{month}{select month}

\item{day}{select date (default \code{NULL})}

\item{cache}{use cash and save to cache.  (\code{TRUE}, the default)}

\item{pack}{Whether to packing common variables or not.  (\code{TRUE}, the default)}

\item{quiet}{Whether to output information on variable and
row combinations that were treated as missing values
for some reason. (\code{TRUE}, the default)}
}
\value{
a \code{tbl} object
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Refer to the data available in the JMA Historical Weather Data Search.
Executed by specifying the target location and date.
Currently, not all types of data acquisition are supported.
}
\note{
The parameter \code{item} chooses one from these:
\itemize{
\item annually: Annual value. Please specify a location by \code{block_no}.
\item monthly: Monthly value. Please specify location and year.
\item 3monthly: Value every 3 months. Please specify location and year.
\item 10daily: Seasonal value. Please specify location and year.
\item mb5daily: Semi-seasonal value. Please specify location and year.
\item daily: Daily value. Please specify location, year and month.
\item hourly: Hourly value. Please specify location, year, month and day.
\item rank: Values of the largest in the history of observations
for each location.
}
}
\examples{
\donttest{
# Annually
jma_collect(item = "annually", "1284", year = 2017, month = 11, cache = FALSE)
# Daily
jma_collect(item = "daily", block_no = "0010", year = 2017, month = 11, cache = FALSE)
jma_collect(item = "daily", "0422", year = 2017, month = 11, cache = FALSE)
# Hourly
jma_collect("hourly", "0010", 2018, 7, 30, cache = FALSE)
# Historical Ranking
jma_collect("rank", block_no = "47646", year = 2020, cache = FALSE)
}
}
