% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_clusters.R
\name{extract_null_cluster_dists}
\alias{extract_null_cluster_dists}
\title{Construct a null distribution of cluster-mass statistics}
\usage{
extract_null_cluster_dists(null_statistics, threshold, binned = FALSE)
}
\arguments{
\item{null_statistics}{A simulation-by-time-by-predictor 3D array of null (permuted) timewise statistics.}

\item{threshold}{The threshold value that the statistic must pass to contribute to cluster mass.
Interpretation differs on the choice of statistic (more below):
\itemize{
\item If \code{statistic = "t"}, the threshold for t-value (beta/std.err) from the regression model.
\item If \code{statistic = "chisq"}, the threshold for the p-value of chi-squared statistics from likelihood ratio tests.
}}

\item{binned}{Whether the data has been aggregated/collapsed into time bins. Defaults to \code{FALSE},
which requires a cluster to span at least two time points. If \code{TRUE}, allows length-1 clusters to exist.}
}
\value{
A \code{null_cluster_dists} object.
}
\description{
Construct a null distribution of cluster-mass statistics
}
\examples{
\dontshow{if (julia_setup_ok()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
\dontshow{
options("jlmerclusterperm.nthreads" = 2)
jlmerclusterperm_setup(verbose = FALSE)
julia_progress(show = FALSE)
}

library(dplyr, warn.conflicts = FALSE)

# Specification object
spec <- make_jlmer_spec(
  weight ~ 1 + Diet, filter(ChickWeight, Time <= 20),
  subject = "Chick", time = "Time"
)
spec

# Null cluster-mass distributions are derived from the permuted timewise statistics
reset_rng_state()
null_statistics <- permute_timewise_statistics(spec, nsim = 100)
null_cluster_dists <- extract_null_cluster_dists(null_statistics, threshold = 2)
null_cluster_dists

# Collect as dataframe with `tidy()`
# - Each simulation contributes one (largest) cluster-mass statistic to the null
# - When no clusters are found, the `sum_statistic` value is zero
null_cluster_dists_df <- tidy(null_cluster_dists)
null_cluster_dists_df

# Changing the `threshold` value changes the shape of the null
extract_null_cluster_dists(null_statistics, threshold = 1)
extract_null_cluster_dists(null_statistics, threshold = 3)

\dontshow{
JuliaConnectoR::stopJulia()
}
}
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=permute_timewise_statistics]{permute_timewise_statistics()}}
}
