% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jlmer.R
\name{jlmer}
\alias{jlmer}
\title{Fit a Julia regression model using jlmer specifications}
\usage{
jlmer(jlmer_spec, family = c("gaussian", "binomial"), ..., progress = FALSE)
}
\arguments{
\item{jlmer_spec}{Data prepped for jlmer from \code{make_jlmer_spec()}}

\item{family}{A GLM family. Currently supports "gaussian" and "binomial".}

\item{...}{Optional arguments passed to Julia for model fitting.}

\item{progress}{If \code{TRUE}, prints the timing of iterations.}
}
\value{
A \code{jlmer_mod} object.
}
\description{
Fit a Julia regression model using jlmer specifications
}
\examples{
\dontshow{if (JuliaConnectoR::juliaSetupOk()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
\dontshow{
options("jlmerclusterperm.nthreads" = 2)
jlmerclusterperm_setup(verbose = FALSE)
julia_progress(show = FALSE)
}

jlmerclusterperm_setup(verbose = FALSE)

# Fitting a regression model with a specification object
spec <- make_jlmer_spec(weight ~ 1 + Diet, ChickWeight)
jlmer(spec)

# `lm()` equivalent
summary(lm(weight ~ 1 + Diet, ChickWeight))$coef

\dontshow{
JuliaConnectoR::stopJulia()
}
}
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=make_jlmer_spec]{make_jlmer_spec()}}
}
