% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crosstab.R
\name{crosstab}
\alias{crosstab}
\alias{crosstab.default}
\alias{crosstab.data.frame}
\title{Generate a crosstabulation of two vectors.}
\usage{
crosstab(...)

\method{crosstab}{default}(vec1, vec2, percent = "none",
  show_na = TRUE, ...)

\method{crosstab}{data.frame}(.data, ...)
}
\arguments{
\item{...}{additional arguments, if calling \code{crosstab} on a data.frame.}

\item{vec1}{the vector to place on the crosstab column.  If supplying a data.frame, this should be an unquoted column name.}

\item{vec2}{the vector to place on the crosstab row.  If supplying a data.frame, this should be an unquoted column name.}

\item{percent}{which grouping to use for percentages, if desired (defaults to "none", which returns simple counts).  Must be one of "none", "row", "col", or "all".}

\item{show_na}{a logical value indicating whether counts should be displayed where either variable is \code{NA}.}

\item{.data}{(optional) a data.frame, in which case \code{vec1} and \code{vec2} should be unquoted column names.}
}
\value{
Returns a data.frame with the frequencies of the crosstabulated variables.
}
\description{
This function is deprecated, use \code{tabyl(dat, var1, var2)} instead.
}
