% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jamba-string.r
\name{renameColumn}
\alias{renameColumn}
\title{Rename columns in a data.frame, matrix, tibble, or GRanges object}
\usage{
renameColumn(x, from, to, verbose = FALSE, ...)
}
\arguments{
\item{x}{\code{data.frame}, \code{matrix}, \code{tbl}, or \code{GRanges} equivalent
object. It will work on any object for which \code{colnames()}
is defined.}

\item{from}{\code{character} vector of colnames expected to be in \code{x}.
Any values that do not match \code{colnames(x)} are ignored.}

\item{to}{\code{character} vector with \code{length(to) == length(from)}
corresponding to the target name for any colnames that
match \code{from}.}

\item{verbose}{\code{logical} indicating whether to print verbose output.}

\item{...}{Additional arguments are ignored.}
}
\value{
\code{data.frame} or object equivalent to the input \code{x},
with columns \code{from} renamed to values in \code{to}. For genomic
ranges objects such as \code{GRanges} and \code{IRanges}, the colnames
are updated in \code{S4Vectors::values(x)}.
}
\description{
Rename columns in a data.frame, matrix, tibble, or GRanges object
}
\details{
This function is intended to rename one or more columns in a
\code{data.frame}, \code{matrix}, tibble, or \code{GRanges} related object.
It will gracefully ignore columns which do not match,
in order to make it possible to call the
function again without problem.

This function will also recognize input objects \code{GRanges},
\code{ucscData}, and \code{IRanges}, which store annotation in \code{DataFrame}
accessible via \code{S4Vectors::values()}. Note the \code{IRanges} package
is required, for its generic function \code{values()}.

The values supplied in \code{to} and \code{from} are converted from \code{factor}
to \code{character} to avoid coersion by R to \code{integer}, which was
noted in output prior to jamba version \verb{0.0.72.900}.
}
\examples{
df <- data.frame(A=1:5, B=6:10, C=11:15);
df;
df2 <- renameColumn(df,
   from=c("A","C"),
   to=c("a_new", "c_new"));
df2;
df3 <- renameColumn(df2,
   from=c("A","C","B"),
   to=c("a_new", "c_new","b_new"));
df3;

}
\seealso{
Other jam practical functions: 
\code{\link{breakDensity}()},
\code{\link{call_fn_ellipsis}()},
\code{\link{checkLightMode}()},
\code{\link{check_pkg_installed}()},
\code{\link{colNum2excelName}()},
\code{\link{color_dither}()},
\code{\link{exp2signed}()},
\code{\link{getAxisLabel}()},
\code{\link{isFALSEV}()},
\code{\link{isTRUEV}()},
\code{\link{jargs}()},
\code{\link{kable_coloring}()},
\code{\link{lldf}()},
\code{\link{log2signed}()},
\code{\link{middle}()},
\code{\link{minorLogTicks}()},
\code{\link{newestFile}()},
\code{\link{printDebug}()},
\code{\link{reload_rmarkdown_cache}()},
\code{\link{rmInfinite}()},
\code{\link{rmNA}()},
\code{\link{rmNAs}()},
\code{\link{rmNULL}()},
\code{\link{setPrompt}()}
}
\concept{jam practical functions}
