% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jamba-colordither.R
\name{color_dither}
\alias{color_dither}
\title{Make dithered color pattern light-dark}
\usage{
color_dither(
  x,
  L_diff = 4,
  L_max = 90,
  L_min = 30,
  min_contrast = 1.25,
  direction = 1,
  returnType = c("vector", "list", "matrix"),
  debug = FALSE,
  ...
)
}
\arguments{
\item{x}{\code{character} vector of R colors}

\item{L_diff}{\code{numeric} value added or subtracted from the L in HSL
color space for each color, until contrast is at least \code{min_contrast}.}

\item{L_max, L_min}{\code{numeric} values that define the permitted range
of L values in HSL color space, which ranges from 0 to 100.}

\item{min_contrast}{\code{numeric} minimum contrast as defined by
\code{colorspace::contrast_ratio()} for the input and potential output
color.}

\item{direction}{\code{numeric} that defines the initial direction,
where values >= 0 start by making colors lighter, and values < 0
make colors darker.}

\item{returnType}{\code{character} string that defines the output of this
function:
\itemize{
\item \code{vector}: two colors for every input color in \code{x}
\item \code{matrix}: two rows, input colors on first row, output colors
on second row
\item \code{list}: a \code{list} with two colors in each element, with input
and output colors together in each vector.
}}

\item{debug}{\code{logical} indicating whether to plot the color iterations
using \code{showColors()}.}

\item{...}{additional arguments are ignored.}
}
\value{
format defined by argument \code{returnType}:
\itemize{
\item \code{vector}: two colors for every input color in \code{x}
\item \code{matrix}: two rows, input colors on first row, output colors
on second row
\item \code{list}: a \code{list} with two colors in each element, with input
and output colors together in each vector.
}
}
\description{
Make dithered color pattern light-dark
}
\details{
This function serves a very simple purpose, mainly for
\code{printDebug()} to use subtle alternating light/dark colors
for vector output. It takes a color and returns two colors
which are slightly lighter and darker than each other,
to a minimum contrast defined by \code{colorspace::contrast_ratio()}.
}
\examples{
x <- "firebrick1";
showColors(color_dither(x))

showColors(color_dither(x, direction=-1))

x <- vigrep("^green[0-9]", grDevices::colors())
showColors(color_dither(x))
showColors(color_dither(x, direction=-1, returnType="list"))

x <- c("green1", "cyan", "blue", "red", "gold", "yellow", "pink")
showColors(color_dither(x))

color_dither(x, debug=TRUE)

}
\seealso{
Other jam practical functions: 
\code{\link{breakDensity}()},
\code{\link{call_fn_ellipsis}()},
\code{\link{checkLightMode}()},
\code{\link{check_pkg_installed}()},
\code{\link{colNum2excelName}()},
\code{\link{exp2signed}()},
\code{\link{getAxisLabel}()},
\code{\link{isFALSEV}()},
\code{\link{isTRUEV}()},
\code{\link{jargs}()},
\code{\link{kable_coloring}()},
\code{\link{lldf}()},
\code{\link{log2signed}()},
\code{\link{middle}()},
\code{\link{minorLogTicks}()},
\code{\link{newestFile}()},
\code{\link{printDebug}()},
\code{\link{reload_rmarkdown_cache}()},
\code{\link{renameColumn}()},
\code{\link{rmInfinite}()},
\code{\link{rmNA}()},
\code{\link{rmNAs}()},
\code{\link{rmNULL}()},
\code{\link{setPrompt}()}
}
\concept{jam practical functions}
