% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jamba.r
\name{pasteByRowOrdered}
\alias{pasteByRowOrdered}
\title{Paste data.frame rows into an ordered factor}
\usage{
pasteByRowOrdered(
  x,
  sep = "_",
  na.rm = TRUE,
  condenseBlanks = TRUE,
  includeNames = FALSE,
  keepOrder = FALSE,
  byCols = seq_len(ncol(x)),
  na.last = TRUE,
  ...
)
}
\arguments{
\item{x}{\code{data.frame}}

\item{sep}{\code{character} separator to use between columns}

\item{na.rm}{\code{logical} whether to remove NA values, or include them as "NA"}

\item{condenseBlanks}{\code{logical} whether to condense blank or empty values
without including an extra delimiter between columns.}

\item{includeNames}{\code{logical} whether to include the colname delimited
prior to the value, using sepName as the delimiter.}

\item{keepOrder}{\code{logical} indicating whether non-factor columns
should order factor levels based upon the existing order of
unique items. This option is intended for \code{data.frame} whose
columns are already sorted in proper order, but where columns
are not \code{factor} with appropriate factor levels. Note that
even when \code{keepOrder=TRUE} all existing \code{factor} columns will
honor the order of factor levels already present in those
columns.}

\item{byCols}{\code{integer} or \code{character} passed to \code{mixedSortDF()}.
This argument defines the order of columns sorted by \code{mixedSortDF()},
and does not affect the order of columns pasted. Columns are
always pasted in the same order they appear in \code{x}. This argument
\code{byCols} was previously passed via \code{...} but is added here
to make this connection more direct.}

\item{na.last}{\code{logical} passed to \code{base::factor()} to determine whether
\code{NA} values are first or last in factor level order.}

\item{...}{additional arguments are passed to \code{jamba::pasteByRow()},
and to \code{jamba::mixedSortDF()}.}
}
\value{
\code{factor} vector whose levels are defined by existing
factor levels, then by sorted values.
}
\description{
Paste data.frame rows into an ordered factor
}
\details{
This function is an extension to \code{jamba::pasteByRow()} which
pastes rows from a \code{data.frame} into a character vector. This
function defines factor levels by running \code{jamba::mixedSortDF(unique(x))}
and calling \code{jamba::pasteByRow()} on the result. Therefore the
original order of the input \code{x} is maintained while the factor
levels are based upon the appropriate column-based sort.

Note that the \code{...} additional arguments are
passed to \code{jamba::mixedSortDF()} to customize the column-based
sort order, used to define factor levels. A good way to test the
order of factors is to run \code{jamba::mixedSortDF(unique(x))} with
appropriate arguments, and confirm the rows are ordered as expected.

Note also that \code{jamba::mixedSortDF()} uses \code{jamba::mixedSort()}
which itself performs alphanumeric sort in order to keep
values in proper numeric order where possible.
}
\examples{
f <- LETTERS;
df <- data.frame(A=f[rep(1:3, each=2)],
   B=c(NA, f[3]),
   C=c(NA, NA, f[2]))
df

# note that output is consistent with mixedSortDF()
jamba::mixedSortDF(df)
jamba::pasteByRowOrdered(df)

jamba::mixedSortDF(df, na.last=FALSE)
jamba::pasteByRowOrdered(df, na.last=FALSE)

jamba::mixedSortDF(df, byCols=c(3, 2, 1))
jamba::pasteByRowOrdered(df, byCols=c(3, 2, 1))

df1 <- data.frame(group=rep(c("Control", "ABC1"), each=6),
   time=rep(c("Hour2", "Hour10"), each=3),
   rep=paste0("Rep", 1:3))
# default will sort each column alphanumerically
pasteByRowOrdered(df1)

# keepOrder=TRUE will honor existing order of character columns
pasteByRowOrdered(df1, keepOrder=TRUE)

}
\seealso{
Other jam string functions: 
\code{\link{asSize}()},
\code{\link{breaksByVector}()},
\code{\link{fillBlanks}()},
\code{\link{formatInt}()},
\code{\link{gsubOrdered}()},
\code{\link{gsubs}()},
\code{\link{makeNames}()},
\code{\link{nameVector}()},
\code{\link{nameVectorN}()},
\code{\link{padInteger}()},
\code{\link{padString}()},
\code{\link{pasteByRow}()},
\code{\link{sizeAsNum}()},
\code{\link{tcount}()},
\code{\link{ucfirst}()}
}
\concept{jam string functions}
