% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jamba-mixedSort.R
\name{mmixedOrder}
\alias{mmixedOrder}
\title{order alphanumeric values from a list}
\usage{
mmixedOrder(
  ...,
  decreasing = FALSE,
  blanksFirst = TRUE,
  na.last = NAlast,
  keepNegative = FALSE,
  keepInfinite = FALSE,
  keepDecimal = FALSE,
  ignore.case = TRUE,
  useCaseTiebreak = TRUE,
  sortByName = FALSE,
  NAlast = TRUE,
  honorFactor = TRUE,
  verbose = FALSE,
  matrixAsDF = TRUE
)
}
\arguments{
\item{...}{arguments treated as a \code{list} of vectors to be ordered in
proper order, based upon the mechanism by \code{base::order()}, and
as such \code{data.frame} is equivalent to a \code{list}.}

\item{decreasing}{\code{logical}, default FALSE, used to reverse the sort order.}

\item{blanksFirst, na.last, keepNegative, keepInfinite, keepDecimal, ignore.case, useCaseTiebreak, sortByName}{arguments passed to \code{mixedOrder()}, except \code{sortByName} which is not
passed along.}

\item{NAlast}{\code{logical} deprecated in favor of argument \code{na.last}
for consistency with \code{base::sort()}.}

\item{honorFactor}{\code{logical}, default TRUE, used to enforce factor level
sort order, when FALSE it sorts as \code{character}.}

\item{verbose}{\code{logical} indicating whether to print verbose output,
passed as \code{verbose - 1} to \code{mixedOrder()}.}

\item{matrixAsDF}{\code{logical} if \code{...} supplies only one matrix object,
then \code{matrixAsDF=TRUE} will cause it to be converted to a \code{data.frame},
then coerce to a \code{list} before processing.
By default, in the event only one matrix object is supplied,
this conversion is performed, in order to define a sort order based upon
each column in order, consistent with behavior of \code{data.frame} input.}
}
\value{
\code{integer} vector of row orders
}
\description{
order alphanumeric values from a list
}
\details{
This function is a minor extension to \code{mixedOrder()},
"multiple \code{mixedOrder()}",
which accepts \code{list} input, similar to how \code{base::order()} operates.
This function is mainly useful when sorting something like a
\code{data.frame}, where ties in column 1 should be maintained then
broken by non-equal values in column 2, and so on.

This function essentially converts any non-numeric column
to a factor, whose levels are sorted using \code{mixedOrder()}.
That factor is converted to numeric value, multiplied by \code{-1}
when \code{decreasing=TRUE}. Finally the list of numeric vectors
is passed to \code{base::order()}.

In fact, \code{mixedSortDF()} calls this \code{mmixedOrder()} function,
in order to sort a \code{data.frame} properly by column.

See \code{mixedOrder()} and \code{mixedSort()} for a better
description of how the sort order logic operates.
}
\examples{
# test factor level order
factor1 <- factor(c("Cnot9", "Cnot8", "Cnot10"))
sort(factor1)
mixedSort(factor1)
factor1[mixedOrder(factor1)]
factor1[mixedOrder(factor1, honorFactor=FALSE)]
factor1[mixedOrder(factor1, honorFactor=TRUE)]

factor1[mmixedOrder(list(factor1))]
factor1[mmixedOrder(list(factor1), honorFactor=FALSE)]
factor1[mmixedOrder(list(factor1), honorFactor=TRUE)]

}
\seealso{
Other jam sort functions: 
\code{\link{mixedOrder}()},
\code{\link{mixedSort}()},
\code{\link{mixedSortDF}()},
\code{\link{mixedSorts}()}
}
\concept{jam sort functions}
