% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jamba-clrange.R
\name{fixYellow}
\alias{fixYellow}
\title{Fix yellow color}
\usage{
fixYellow(col, Hrange = c(70, 100), Hshift = -20, fixup = TRUE, ...)
}
\arguments{
\item{col}{R color, either in hex color format or using values from
\code{grDevices::colors()}.}

\item{Hrange}{numeric vector whose range defines the region of hues
to be adjusted. By default hues between 80 and 90 are adjusted. If
NULL, \code{HCL} is return unchanged.}

\item{Hshift}{numeric value length one, used to adjust the hue of colors
within the range \code{Hrange}. If NULL, \code{HCL} is return unchanged.}

\item{fixup}{\code{logical}, default TRUE, whether to apply fixup to
the resulting color, passed to \code{hcl2col()}}

\item{...}{additional arguments are passed to \code{col2hcl()}, and
\code{hcl2col()}.}
}
\value{
returns a vector of R colors the same length as input \code{col}.
In the event \code{col}, \code{Hrange}, or \code{Hshift} have length 0, or if any
step in the conversion produces length 0, then the
original \code{col} is returned.
}
\description{
Fix yellow color to be less green than default "yellow"
}
\details{
This function "fixes" the color yellow, which by default appears green
especially when darkened. The effect of this function is to make yellows
appear more red, which appears more visibly yellow even when the color
is darkened.

This function is intended to be tolerant to missing values. For example if
any of the values \code{col}, \code{Hrange}, or \code{Hshift} are length 0, the original
\code{col} is returned unchanged.
}
\examples{
yellows <- vigrep("yellow", grDevices::colors());
fixedYellows <- fixYellow(yellows);
showColors(list(yellows=yellows,
   fixedYellows=fixedYellows));

}
\seealso{
Other jam color functions: 
\code{\link{alpha2col}()},
\code{\link{applyCLrange}()},
\code{\link{col2alpha}()},
\code{\link{col2hcl}()},
\code{\link{col2hsl}()},
\code{\link{col2hsv}()},
\code{\link{color2gradient}()},
\code{\link{fixYellowHue}()},
\code{\link{getColorRamp}()},
\code{\link{hcl2col}()},
\code{\link{hsl2col}()},
\code{\link{hsv2col}()},
\code{\link{isColor}()},
\code{\link{kable_coloring}()},
\code{\link{makeColorDarker}()},
\code{\link{rainbow2}()},
\code{\link{rgb2col}()},
\code{\link{setCLranges}()},
\code{\link{setTextContrastColor}()},
\code{\link{showColors}()},
\code{\link{unalpha}()},
\code{\link{warpRamp}()}
}
\concept{jam color functions}
