% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jamba-plots.r
\name{breakDensity}
\alias{breakDensity}
\title{Calculate more detailed density of numeric values}
\usage{
breakDensity(
  x,
  breaks = length(x)/3,
  bw = NULL,
  width = NULL,
  densityBreaksFactor = 3,
  weightFactor = 1,
  addZeroEnds = TRUE,
  baseline = 0,
  floorBaseline = FALSE,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{x}{numeric vector}

\item{breaks}{numeric breaks as described for \code{stats::density()} except
that single integer value is multiplied by \code{densityBreaksFactor}.}

\item{bw}{character name of a bandwidth function, or NULL.}

\item{width}{NULL or numeric value indicating the width of breaks to
apply.}

\item{densityBreaksFactor}{numeric factor to adjust the width of
density breaks, where higher values result in less detail.}

\item{weightFactor}{optional vector of weights \code{length(x)} to apply
to the density calculation.}

\item{addZeroEnds}{logical indicating whether the start and end value
should always be zero, which can be helpful for creating a polygon.}

\item{baseline}{optional numeric value indicating the expected baseline,
which is typically zero, but can be set to a higher value to indicate
a "noise floor".}

\item{floorBaseline}{logical indicating whether to apply a noise floor
to the output data.}

\item{verbose}{logical indicating whether to print verbose output.}

\item{...}{additional parameters are sent to \code{stats::density()}.}
}
\value{
\code{list} output equivalent to \code{stats::density()}:
\itemize{
\item \code{x}: The \code{n} coordinates of the points where the density is
estimated.
\item \code{y}: The estimated density values, non-negative, but can be zero.
\item \code{bw}: The bandidth used.
\item \code{n}: The sample size after elimination of missing values.
\item \code{call}: the call which produced the result.
\item \code{data.name}: the deparsed name of the \code{x} argument.
\item \code{has.na}: \code{logical} for compatibility, and always \code{FALSE}.
}
}
\description{
Calculate more detailed density of numeric values
}
\details{
This function is a drop-in replacement for \code{stats::density()},
simply to provide a quick alternative that defaults to a higher
level of detail. Detail can be adjusted using \code{densityBreaksFactor},
where higher values will use a wider step size, thus lowering
the detail in the output.

Note that the density height is scaled by the total number of points,
and can be adjusted with \code{weightFactor}. See Examples for how to
scale the y-axis range similar to \code{stats::density()}.
}
\examples{
x <- c(stats::rnorm(15000),
   stats::rnorm(5500)*0.25 + 1,
   stats::rnorm(12500)*0.5 + 2.5)
plot(stats::density(x))

plot(breakDensity(x))

plot(breakDensity(x, densityBreaksFactor=200))

# trim values to show abrupt transitions
x2 <- x[x > 0 & x < 4]
plot(stats::density(x2), lwd=2)
lines(breakDensity(x2, weightFactor=1/length(x2)/10), col="red")
graphics::legend("topright", c("stats::density()", "breakDensity()"),
   col=c("black", "red"), lwd=c(2, 1))

}
\seealso{
Other jam practical functions: 
\code{\link{call_fn_ellipsis}()},
\code{\link{checkLightMode}()},
\code{\link{check_pkg_installed}()},
\code{\link{colNum2excelName}()},
\code{\link{color_dither}()},
\code{\link{exp2signed}()},
\code{\link{getAxisLabel}()},
\code{\link{isFALSEV}()},
\code{\link{isTRUEV}()},
\code{\link{jargs}()},
\code{\link{kable_coloring}()},
\code{\link{lldf}()},
\code{\link{log2signed}()},
\code{\link{middle}()},
\code{\link{minorLogTicks}()},
\code{\link{newestFile}()},
\code{\link{printDebug}()},
\code{\link{reload_rmarkdown_cache}()},
\code{\link{renameColumn}()},
\code{\link{rmInfinite}()},
\code{\link{rmNA}()},
\code{\link{rmNAs}()},
\code{\link{rmNULL}()},
\code{\link{setPrompt}()}
}
\concept{jam practical functions}
