% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jackstraw_MiniBatchKmeans.R
\name{jackstraw_MiniBatchKmeans}
\alias{jackstraw_MiniBatchKmeans}
\title{Non-Parametric Jackstraw for Mini Batch K-means Clustering}
\usage{
jackstraw_MiniBatchKmeans(dat, MiniBatchKmeans.output = NULL, s = NULL,
  B = NULL, center = TRUE, covariate = NULL, verbose = FALSE,
  seed = NULL, batch_size = floor(nrow(dat)/100),
  initializer = "kmeans++", pool = TRUE, ...)
}
\arguments{
\item{dat}{a data matrix with \code{m} rows as variables and \code{n} columns as observations.}

\item{MiniBatchKmeans.output}{an output from applying \code{ClusterR::MiniBatchKmeans()} onto \code{dat}. This provides more controls over the algorithm and subsequently the initial centroids used.}

\item{s}{a number of ``synthetic'' null variables. Out of \code{m} variables, \code{s} variables are independently permuted.}

\item{B}{a number of resampling iterations.}

\item{center}{a logical specifying to center the rows. By default, \code{TRUE}.}

\item{covariate}{a model matrix of covariates with \code{n} observations. Must include an intercept in the first column.}

\item{verbose}{a logical specifying to print the computational progress. By default, \code{FALSE}.}

\item{seed}{a seed for the random number generator.}

\item{batch_size}{the size of the mini batches.}

\item{initializer}{the method of initialization. By default, \code{kmeans++}.}

\item{pool}{a logical specifying to pool the null statistics across all clusters. By default, \code{TRUE}.}

\item{...}{optional arguments to control the Mini Batch K-means clustering algorithm (refers to \code{ClusterR::MiniBatchKmeans}).}
}
\value{
\code{jackstraw_MiniBatchKmeans} returns a list consisting of
\item{F.obs}{\code{m} observed F statistics between variables and cluster centers.}
\item{F.null}{F null statistics between null variables and cluster centers, from the jackstraw method.}
\item{p.F}{\code{m} p-values of membership.}
}
\description{
Test the cluster membership for K-means clustering
}
\details{
K-means clustering assign \code{m} rows into \code{K} clusters. This function enable statistical
evaluation if the cluster membership is correctly assigned. Each of \code{m} p-values refers to
the statistical test of that row with regard to its assigned cluster.
Its resampling strategy accounts for the over-fitting characteristics due to direct computation of clusters from the observed data
and protects against an anti-conservative bias.
}
\examples{
\dontrun{
library(ClusterR)
set.seed(1234)
dat = t(scale(t(Jurkat293T), center=TRUE, scale=FALSE))
MiniBatchKmeans.output <- MiniBatchKmeans(data=dat, clusters = 2, batch_size = 300,
initializer = "kmeans++")
jackstraw.output <- jackstraw_MiniBatchKmeans(dat,
MiniBatchKmeans.output = MiniBatchKmeans.output)
}
}
\references{
Chung (2018) Statistical significance for cluster membership. biorxiv, doi:10.1101/248633 \url{https://www.biorxiv.org/content/early/2018/01/16/248633}
}
\author{
Neo Christopher Chung \email{nchchung@gmail.com}
}
