% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaa-classes.R
\name{haplotypes}
\alias{haplotypes}
\title{An R6 Class Representing Haploid Variants}
\description{
Interactive wrapper for a pointer to a C++ object that stores information about
variant haplotypes from a single reference genome.
}
\details{
This class should NEVER be created using \code{haplotypes$new}.
Only use \code{create_haplotypes}.
Because this class wraps a pointer to a C++ object, there are no fields to
manipulate directly.
All manipulations are done through this class's methods.
}
\section{Connections to \code{ref_genome} objects}{

Regarding the \code{ref_genome} object you use to create a \code{haplotypes} object, you should
note the following:

\itemize{
\item \strong{This point is the most important.}
Both the \code{ref_genome} and \code{haplotypes} objects use the same underlying
C++ object to store reference genome information.
Thus, if you make any changes to the \code{ref_genome} object, those changes will
also show up in the \code{haplotypes} object.
For example, if you make a \code{haplotypes} object named \code{V}
based on an existing \code{ref_genome} object named \code{R},
then you merge chromosomes in \code{R},
\code{V} will now have merged chromosomes.
If you've already started adding mutations to \code{V},
then all the indexes used to store those mutations will be inaccurate.
So when you do anything with \code{V} later, your R session will crash
or have errors.
\strong{The lesson here is that you shouldn't edit the reference
genome after using it to create haplotypes.}
\item If a \code{ref_genome} object is used to create a \code{haplotypes}
object, deleting the \code{ref_genome} object won't cause issues with
the \code{haplotypes} object.
However, the \code{haplotypes} class doesn't provide methods to edit
chromosomes, so only remove the \code{ref_genome} object when you're done
editing the reference genome.
}
}

\seealso{
\code{\link{create_haplotypes}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{haplotypes$new()}}
\item \href{#method-print}{\code{haplotypes$print()}}
\item \href{#method-ptr}{\code{haplotypes$ptr()}}
\item \href{#method-n_chroms}{\code{haplotypes$n_chroms()}}
\item \href{#method-n_haps}{\code{haplotypes$n_haps()}}
\item \href{#method-sizes}{\code{haplotypes$sizes()}}
\item \href{#method-chrom_names}{\code{haplotypes$chrom_names()}}
\item \href{#method-hap_names}{\code{haplotypes$hap_names()}}
\item \href{#method-chrom}{\code{haplotypes$chrom()}}
\item \href{#method-gc_prop}{\code{haplotypes$gc_prop()}}
\item \href{#method-nt_prop}{\code{haplotypes$nt_prop()}}
\item \href{#method-set_names}{\code{haplotypes$set_names()}}
\item \href{#method-add_haps}{\code{haplotypes$add_haps()}}
\item \href{#method-dup_haps}{\code{haplotypes$dup_haps()}}
\item \href{#method-rm_haps}{\code{haplotypes$rm_haps()}}
\item \href{#method-add_sub}{\code{haplotypes$add_sub()}}
\item \href{#method-add_ins}{\code{haplotypes$add_ins()}}
\item \href{#method-add_del}{\code{haplotypes$add_del()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\subsection{Method \code{new()}}{
Do NOT use this; only use \code{create_haplotypes} to make new \code{haplotypes}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{haplotypes$new(genomes_ptr, reference_ptr)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{genomes_ptr}}{An \code{externalptr} object pointing to a C++ object that
stores the information about the haplotypes.}

\item{\code{reference_ptr}}{An \code{externalptr} object pointing to a C++ object that
stores the information about the reference genome.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\subsection{Method \code{print()}}{
Print a \code{haplotypes} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{haplotypes$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ptr"></a>}}
\subsection{Method \code{ptr()}}{
View pointer to underlying C++ object (this is not useful to end users).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{haplotypes$ptr()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
An \code{externalptr} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-n_chroms"></a>}}
\subsection{Method \code{n_chroms()}}{
View number of chromosomes.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{haplotypes$n_chroms()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Integer number of chromosomes.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-n_haps"></a>}}
\subsection{Method \code{n_haps()}}{
View number of haplotypes.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{haplotypes$n_haps()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Integer number of haplotypes.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-sizes"></a>}}
\subsection{Method \code{sizes()}}{
View chromosome sizes for one haplotype.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{haplotypes$sizes(hap_ind)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{hap_ind}}{Index for the focal haplotype.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Integer vector of chromosome sizes for focal haplotype.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-chrom_names"></a>}}
\subsection{Method \code{chrom_names()}}{
View chromosome names.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{haplotypes$chrom_names()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Character vector of chromosome names.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-hap_names"></a>}}
\subsection{Method \code{hap_names()}}{
View haplotype names.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{haplotypes$hap_names()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Character vector of haplotype names.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-chrom"></a>}}
\subsection{Method \code{chrom()}}{
View one haplotype chromosome.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{haplotypes$chrom(hap_ind, chrom_ind)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{hap_ind}}{Index for the focal haplotype.}

\item{\code{chrom_ind}}{Index for the focal chromosome.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A single string representing the chosen haplotype chromosome's DNA
sequence.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-gc_prop"></a>}}
\subsection{Method \code{gc_prop()}}{
View GC proportion for part of one haplotype chromosome.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{haplotypes$gc_prop(hap_ind, chrom_ind, start, end)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{hap_ind}}{Index for the focal haplotype.}

\item{\code{chrom_ind}}{Index for the focal chromosome.}

\item{\code{start}}{Point on the chromosome at which to start the calculation
(inclusive).}

\item{\code{end}}{Point on the chromosome at which to end the calculation
(inclusive).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A double in the range \verb{[0,1]} representing the proportion of DNA
sequence that is either \code{G} or \code{C}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-nt_prop"></a>}}
\subsection{Method \code{nt_prop()}}{
View nucleotide content for part of one haplotype chromosome
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{haplotypes$nt_prop(nt, hap_ind, chrom_ind, start, end)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{nt}}{Which nucleotide to calculate the proportion that the DNA
sequence is made of. Must be one of \code{T}, \code{C}, \code{A}, \code{G}, or \code{N}.}

\item{\code{hap_ind}}{Index for the focal haplotype.}

\item{\code{chrom_ind}}{Index for the focal chromosome.}

\item{\code{start}}{Point on the chromosome at which to start the calculation
(inclusive).}

\item{\code{end}}{Point on the chromosome at which to end the calculation
(inclusive).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A double in the range \verb{[0,1]} representing the proportion of DNA
sequence that is \code{nt}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-set_names"></a>}}
\subsection{Method \code{set_names()}}{
Change haplotype names.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{haplotypes$set_names(new_names)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{new_names}}{Vector of new names to use. This must be the same length as
the number of current names.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
This \code{R6} object, invisibly.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-add_haps"></a>}}
\subsection{Method \code{add_haps()}}{
Add one or more blank, named haplotypes
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{haplotypes$add_haps(new_names)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{new_names}}{Vector of name(s) for the new haplotype(s).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
This \code{R6} object, invisibly.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-dup_haps"></a>}}
\subsection{Method \code{dup_haps()}}{
Duplicate one or more haplotypes by name.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{haplotypes$dup_haps(hap_names, new_names = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{hap_names}}{Vector of existing haplotype name(s) that you want to
duplicate.}

\item{\code{new_names}}{Optional vector specifying the names of the duplicates.
If \code{NULL}, their names are auto-generated. Defaults to \code{NULL}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
This \code{R6} object, invisibly.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rm_haps"></a>}}
\subsection{Method \code{rm_haps()}}{
Remove one or more haplotypes by name.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{haplotypes$rm_haps(hap_names)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{hap_names}}{Vector of existing haplotype name(s) that you want to remove.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
This \code{R6} object, invisibly.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-add_sub"></a>}}
\subsection{Method \code{add_sub()}}{
Manually add a substitution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{haplotypes$add_sub(hap_ind, chrom_ind, pos, nt)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{hap_ind}}{Index for the focal haplotype.}

\item{\code{chrom_ind}}{Index for the focal chromosome.}

\item{\code{pos}}{Position at which to add the mutation.}

\item{\code{nt}}{Single character representing the nucleotide to change the
current one to.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
This \code{R6} object, invisibly.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-add_ins"></a>}}
\subsection{Method \code{add_ins()}}{
Manually add an insertion.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{haplotypes$add_ins(hap_ind, chrom_ind, pos, nts)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{hap_ind}}{Index for the focal haplotype.}

\item{\code{chrom_ind}}{Index for the focal chromosome.}

\item{\code{pos}}{Position at which to add the mutation.}

\item{\code{nts}}{String representing the nucleotide(s) that will be inserted after
the designated position.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
This \code{R6} object, invisibly.\preformatted{\\item\{`add_del(hap_ind, chrom_ind, pos, n_nts)`\}\{Manually add a deletion
    for a given haplotype (`hap_ind`), chromosome (`chrom_ind`), and position (`pos`).
    The designated number of nucleotides to delete (`n_nts`) will be deleted
    starting at `pos`, unless `pos` is near the chromosome end and doesn't have
    `n_nts` nucleotides to remove; it simply stops at the chromosome end in
    this case.\}
}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-add_del"></a>}}
\subsection{Method \code{add_del()}}{
Manually add a deletion.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{haplotypes$add_del(hap_ind, chrom_ind, pos, n_nts)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{hap_ind}}{Index for the focal haplotype.}

\item{\code{chrom_ind}}{Index for the focal chromosome.}

\item{\code{pos}}{Position at which to add the mutation.}

\item{\code{n_nts}}{Single integer specifying the number of nucleotides to delete.
These will be deleted starting at \code{pos}.
If \code{pos} is near the chromosome end and doesn't have \code{n_nts} nucleotides
to remove, it simply removes nucleotides from \code{pos} to the chromosome end.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
This \code{R6} object, invisibly.
}
}
}
