test.fitGlm <- function() {
  # poisson.independent
  glms.fitted.csi <- fitGlm(sim.data.csi, jaatha.csi) 
  checkTrue( is.list(glms.fitted.csi) )
  checkEquals( length(glms.fitted.csi), 1 )

  checkEquals( length(glms.fitted.csi$poisson.vector), 
              length(sim.data.csi[[1]]$poisson.vector) )
  checkTrue( all(sapply(glms.fitted.csi$poisson.vector, is)[1, ] == "glm") )

  # poisson.transformed
  glms.fitted.tt <- fitGlm(sim.data.tt, jaatha.tt) 
  checkTrue( is.list(glms.fitted.tt) )
  checkEquals( length(glms.fitted.tt), 1 )

  checkTrue( is.list(glms.fitted.tt$jsfs) )
  checkEquals( length(glms.fitted.tt$jsfs), 
              length(jaatha.tt@sum.stats$jsfs$value.transformed) )
  checkTrue( all(sapply(glms.fitted.tt$jsfs, is)[1, ] == "glm") )

  # poisson.smoothed
  glms.fitted.smooth <- fitGlm(smooth.sim.data, smooth.jaatha)
  checkTrue( is.list(glms.fitted.smooth) )
  checkEquals( length(glms.fitted.smooth), 1 )

  checkTrue( is.list(glms.fitted.smooth$mat) )
  checkEquals( length(glms.fitted.smooth$mat), 1 )
  checkTrue( "glm" %in% is(glms.fitted.smooth$mat[[1]]))
}

test.convertSimResultsToDataFrame <- function() {
  smooth.df <- convertSimResultsToDataFrame(smooth.sim.data, "mat")
  checkTrue( is.data.frame(smooth.df) )
  checkEquals( ncol(smooth.df), 5 )
  checkEquals( nrow(smooth.df),
              length(as.vector(smooth.sim.data[[1]]$mat))*length(smooth.sim.data))
  checkTrue( !is.null(colnames(smooth.df)) )
  checkTrue( all(colnames(smooth.df) == c("x", "y", "X1", "X2", "sum.stat")) )

  smooth.df <- convertSimResultsToDataFrame(smooth.sim.data,
                                            "mat",
                                            smooth.border.sum.stats$mat$border.mask)
  checkTrue( is.data.frame(smooth.df) )
  checkEquals( ncol(smooth.df), 5 )
  checkTrue( all(smooth.df$X1 %in% 1:10) )
  checkTrue( all(smooth.df$X2 %in% 1:12) )

  test.sim.data <- list(list(pars.normal=c(u=1, v=2, w=3), ar=array(1, c(2,3,4))))
  smooth.df <- convertSimResultsToDataFrame(test.sim.data, "ar")
  checkTrue( is.data.frame(smooth.df) )
  checkEquals(c(24,7), dim(smooth.df) )
  checkTrue( all(colnames(smooth.df) == c("u", "v", "w", "X1", "X2", "X3", "sum.stat")) )
}

test.fitGlm.Smoothing <- function() {
  glm.fitted <- fitGlm(smooth.sim.data, smooth.jaatha)
  checkTrue( is.list(glm.fitted$mat) )
  checkEquals( length(glm.fitted$mat), 1 )
  checkTrue( "glm" %in% is(glm.fitted$mat[[1]]))
}

test.fitGlm.Smoothing.border <- function() {
  glm.fitted <- fitGlm(smooth.sim.data, smooth.border.jaatha)
  checkTrue( is.list(glm.fitted$mat) )
  checkEquals( length(glm.fitted$mat), 2 )
  checkTrue( "glm" %in% is(glm.fitted$mat[['smooth']]))
  checkTrue( is.list(glm.fitted$mat$border) )
  checkEquals( length(glm.fitted$mat$border), 40 )
}
