% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/future_worldclim2.R
\name{future_worldclim2}
\alias{future_worldclim2}
\title{A function to parse the future climate from worldclim version 2.1.}
\usage{
future_worldclim2(
  var = "tmin",
  res = 10,
  gcm = "BCC-CSM2-MR",
  ssp = "ssp585",
  interval = "2021-2040",
  bry = NULL,
  path = NULL,
  nm_mark = "clip",
  return_stack = TRUE
)
}
\arguments{
\item{var}{(\code{character}) The option for the variable to download.
Should be one of tmin, tmax, prec, bioc.
The default is tmin.}

\item{res}{(\code{numeric}) The option for the resolution of image to
download. Should be one of 2.5, 5, 10. The default is 10.}

\item{gcm}{(\code{character}) The option for global climate models.
Should be one of "BCC-CSM2-MR", "CNRM-CM6-1","CNRM-ESM2-1", "CanESM5",
"GFDL-ESM4", "IPSL-CM6A-LR","MIROC-ES2L", "MIROC6", "MRI-ESM2-0".
The default is 'BCC-CSM2-MR'.}

\item{ssp}{(\code{character}) The option for Shared Socio-economic Pathways.
Should be one of "ssp126", "ssp245", "ssp370", "ssp585".
The default is "ssp585".}

\item{interval}{(\code{character}) The option for time interval.
Should be one of "2021-2040", "2041-2060", "2061-2080", "2081-2100".
The default is "2021-2040".}

\item{bry}{(\code{\link{sf}} or \code{sp}) The boundary to mask the
downloaded original data. If \code{NULL}, it would get global map.
If not \code{NULL}, it can take \code{\link{sf}},  \code{\link{sfc}},
\code{SpatialPolygonsDataFrame}, \code{SpatialPolygons}, etc.
The default is \code{NULL}.}

\item{path}{(\code{character}) The path to save the downloaded imagery.
If \code{NULL}, it would use the current working directory.
The default is \code{NULL}.}

\item{nm_mark}{(\code{character}) the name mark of clipped images.
The default is "clip". It would be ignored if \code{bry} is \code{NULL}.}

\item{return_stack}{(\code{logical}) if \code{TRUE}, stack the imagery
together and return.
If the area is large and resolution is high, it is better not to stack them.
The default is \code{TRUE}.}
}
\value{
if \code{return_stack} is \code{TRUE}, the images would be
returned as a \code{stars}. Otherwise, nothing to return, but the user
would receive a message of where the images are.
}
\description{
This function allows you to parse worldclim version 2.1
future climatic files with a setting of boundary and a few other options.
}
\details{
\href{https://worldclim.org/data/index.html}{Web page page for this dataset}
}
\note{
If it fails due to slow internet, try to set a larger timeout option,
e.g., using \code{options(timeout = 1e3)}.
}
\examples{
\dontrun{
future_worldclim2("tmin", 10, "BCC-CSM2-MR",
  "ssp585", "2021-2040",
  path = tempdir(), return_stack = FALSE)
}

}
\references{
Fick, Stephen E., and Robert J.
Hijmans. "WorldClim 2: new 1-km spatial resolution climate surfaces for
global land areas." \emph{International journal of climatology}
37.12 (2017): 4302-4315.\doi{10.1002/joc.5086}
}
