% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{fadeRug}
\alias{fadeRug}
\title{Fade out the areas in a surface without data.}
\usage{
fadeRug(x, y, n.grid = 30, too.far = 0.03, col = "white", alpha = 1,
  use.data.range = TRUE)
}
\arguments{
\item{x}{Observations on x-axis.}

\item{y}{Observations on y-axis.}

\item{n.grid}{Resolution of Rug. Defaults to 30, 
which means that the x- and y-axis are divided in 30 bins. 
A two-value vector ould be used to specify different bins for 
x- and y-axis.}

\item{too.far}{plot grid nodes that are too far from the points defined by 
the variables given in view can be excluded from the plot. too.far 
determines what is too far. The grid is scaled into the unit square along 
with the view variables and then grid nodes more than too.far from the 
predictor variables are excluded. Based on 
\code{\link[mgcv]{exclude.too.far}} of Simon N. Wood.}

\item{col}{Color representing missing data. Defaults to "white".}

\item{alpha}{Transparency, number between 0 (completely 
transparent) and 1 (non-transparent). Defaults to 1.}

\item{use.data.range}{Logical value, indicating whether \code{x} and 
\code{y} are the data that the plot is based on. Defaults to TRUE.}
}
\value{
Plots a shaded image over the contour plot or image.
}
\description{
Add a transparency Rug to a contour plot or image.
}
\section{Warning}{

On Linux \code{\link{x11}} devices may not support transparency. 
In that case, a solution might be to write the plots immediately to a file 
using functions such as \code{\link{pdf}}, or \code{\link{png}}.
}

\examples{
data(simdat)

# Introduce extreme values:
set.seed(123)
newdat <- simdat[sample(which(simdat$Time < 1500),
    size=round(.5*length(which(simdat$Time < 1500)))),]
newdat <- rbind(newdat, 
    simdat[sample(which(simdat$Time > 1500),
    size=5),])
# Some simple GAM with tensor:
m1 <- bam(Y ~ te(Time, Trial), data=newdat)
# plot summed effects:
fvisgam(m1, view=c("Time", "Trial"), zlim=c(-15,15))
fadeRug(newdat$Time, newdat$Trial)
# check with data points:
points(newdat$Time, newdat$Trial, pch=16, col=alpha(1))

# compare with default rug:
fvisgam(m1, view=c("Time", "Trial"), zlim=c(-15,15))
rug(newdat$Time)
rug(newdat$Trial, side=2)
fadeRug(newdat$Time, newdat$Trial)
# and compare with too.far:
fvisgam(m1, view=c("Time", "Trial"), zlim=c(-15,15),
    too.far=.03)
vis.gam(m1, view=c("Time", "Trial"), zlim=c(-15,15),
    too.far=.03, plot.type="contour", color="topo")

# in case fade rug overlaps with color legend:
fvisgam(m1, view=c("Time", "Trial"), zlim=c(-15,15),
     add.color.legend=FALSE)
fadeRug(newdat$Time, newdat$Trial, alpha=.75)
gradientLegend(c(-15,15), pos=.875)

# change x- and y-grid, and color:
fvisgam(m1, view=c("Time", "Trial"), zlim=c(-15,15))
points(newdat$Time, newdat$Trial)
fadeRug(newdat$Time, newdat$Trial, n.grid=c(100,10), col='gray')
}
\seealso{
\code{\link[graphics]{rug}}, \code{\link[graphics]{contour}}, 
\code{\link[graphics]{image}}

Other Functions for plotting: \code{\link{rug_model}}
}
\author{
Jacolien van Rij, based on Simon N. Wood's 
\code{\link[mgcv]{exclude.too.far}}
}
