% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{marginDensityPlot}
\alias{marginDensityPlot}
\title{Plot density of distribution in margins of the plot.}
\usage{
marginDensityPlot(x, y = NULL, side, from = 0, maxDensityValue = NULL,
  allDensities = NULL, plot = TRUE, ...)
}
\arguments{
\item{x}{Density object, or vector with x-values.}

\item{y}{If \code{x} is not a density object, the vector \code{y} 
provides the y-values to plot.}

\item{side}{Number: 1 = bottom, 2 = left, 3 = top, 4 = left}

\item{from}{A number indicating the starting position (bottom) of the 
density plot. Defaults to 0, which is the border of the plot. 
Measured in proportions of the margin area available. Note that  
value could be negative (starting in the plot region).}

\item{maxDensityValue}{Number for scaling the density axis. 
Default is NULL (automatic scaling fitting the d)}

\item{allDensities}{List with other density objects to determine 
the plotting scale such that they all fit. Defaults to NULL.}

\item{plot}{Logical: whether to plot the density (default) or not.}

\item{...}{Optional arguments for the lines and fill_area. See \code{\link{par}}.}
}
\description{
Plot density of distribution in margins of the plot.
}
\examples{
# density of a random sample from normal distribution:
val1 <- qnorm(ppoints(500))
val2 <- qt(ppoints(500), df = 2)
dens1 <- density(val1)
dens2 <- density(val2)

# setup plot window:
par(mfrow=c(1,1), cex=1.1)

# increase margin
oldmar <- par()$mar 
par(mar=oldmar + c(0,0,0,4))

# plot qqnorm
qqnorm(val2, main='t distribution',
       pch="*", col='steelblue',
       xlim=c(-3,3),
       bty='n')
qqline(val1)
abline(h=0, col=alpha('gray'))
abline(v=0, col=alpha('gray'))

# filled distribution in right margin:
marginDensityPlot(dens2, side=4, allDensities=list(dens1, dens2),
	col='steelblue',lwd=2)
# add lines:
marginDensityPlot(dens2, side=4, allDensities=list(dens1, dens2),
	col='steelblue',density=25, lwd=2)
# compare to normal:
marginDensityPlot(dens1, side=4, allDensities=list(dens1, dens2), 
	col=NA, border=1)
# Other sides are also possible:
marginDensityPlot(dens1, side=3, allDensities=list(dens1, dens2), 
	col=NA, border=alpha(1), lwd=2)
marginDensityPlot(dens2, side=3, allDensities=list(dens1, dens2), 
	col=NA, border=alpha('steelblue'), lwd=3)
# adjust the starting point with argument from:
marginDensityPlot(dens1, side=1, 
	from=.5, lwd=2)
marginDensityPlot(dens2, side=1, 
	col='steelblue', from=-.90, lwd=2,
 maxDensityValue=2*max(dens2$y))

legend(getFigCoords('p')[2], getFigCoords('p')[3],
	yjust=0,
	legend=c("t distribution", "Gaussian"),
	fill=c("steelblue", 'black'),
	cex=.75,
	xpd=TRUE, bty='n')


}
\author{
Jacolien van Rij
}
\seealso{
\code{\link{check_normaldist}}

Other Functions for plotting: \code{\link{addInterval}},
  \code{\link{add_bars}}, \code{\link{alphaPalette}},
  \code{\link{alpha}}, \code{\link{check_normaldist}},
  \code{\link{color_contour}}, \code{\link{dotplot_error}},
  \code{\link{drawArrows}}, \code{\link{emptyPlot}},
  \code{\link{errorBars}}, \code{\link{fadeRug}},
  \code{\link{fill_area}}, \code{\link{getCoords}},
  \code{\link{getFigCoords}}, \code{\link{getProps}},
  \code{\link{gradientLegend}}, \code{\link{plot_error}},
  \code{\link{plot_image}}, \code{\link{plotsurface}},
  \code{\link{rug_model}}
}

