% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wx.R
\name{wx}
\alias{wx}
\title{Bootstrap estimation for the tuning parameter for the predictor variables.}
\usage{
wx(y,x,d,wx_seq=seq(0.1,5,by=.1),wy=1,wh=1.5,B=500,space="mean",
                                               xdensity="normal",method="FM")
}
\arguments{
\item{y}{The n-dimensional response vector.}

\item{x}{The design matrix of the predictors with dimension n-by-p.}

\item{d}{An integer specifying the dimension of the sufficient dimension reduction subspace.}

\item{wx_seq}{(default 0.1,0.2,...,0.5). A sequence of candidiate tuning parameter for the predictor variables.}

\item{wy}{(default 1). The tuning parameter for the response variable.}

\item{wh}{(default 1.5). The bandwidth of the kernel density estimation function.}

\item{B}{(default 500). Number of boostrap samples.}

\item{space}{(default ``mean''). The defalult is ``mean'' for the central mean subspace. Other option is ``pdf'' for estimating the central subspace.}

\item{xdensity}{(default ``normal''). Density function of the predictor variables. 
If ``normal'' then predictor variables are coming from a multivariate normal distribution. 
If ``elliptic''  then predictors are coming from an elliptical contoured distribution. 
If the distribution of the predictor variables is unknown, then use ``kernel'' to estimate the distribution 
function using kernel smoothing method.}

\item{method}{(default ``FM''). The integral transformation method. ``FM'' for Fourier trans-formation method (Zhu and Zeng 2006), and
``CM'' for convolution transformation method (Zeng and Zhu 2010).}
}
\value{
The outputs are a table of average boostrap distances between two subspaces for each candidate value of wx and estimated value of wx.
\item{dis_wx}{A table of average boostrap distances for each candidate value of wx.}

\item{wx.hat}{The estimated value for tunning parameter \eqn{\sigma_w^2}.}
}
\description{
\emph{wx()} estimates the turning parameter for the predictors which required in both `FM` and `CM` methods.
}
\references{
Zeng P. and Zhu Y. (2010).
An Integral Transform Method for Estimating the Central Mean and Central Subspaces. \emph{Journal of Multivariate Analysis}. 101, 1, 271--290.

Zhu Y. and Zeng P. (2006).
Fourier Methods for Estimating the Central Subspace and Central Mean Subspace in Regression. \emph{Journal of the American Statistical Association}. 101, 476, 1638--1651.
}
