% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Trait.R
\name{fitness}
\alias{fitness}
\alias{set_infty}
\alias{set_quant}
\title{Simulated Trait for Individuals According to Basic Models}
\usage{
set_infty(specie, m = 0, a = 1, d = 0, genes = NULL)

set_quant(specie, m, data)
}
\arguments{
\item{specie}{an instance of the R6 class Specie with the genome's parameters.}

\item{m, a, d}{a length-one numeric vector with respectively the mean, the 
additive and the dominant effects.}

\item{genes}{a character vector with the putative genes.}

\item{data}{a data frame with the genes (snp) and their additive and dominant 
effects}
}
\value{
Objects of R6 class with methods to mimic in silico Traits.
}
\description{
Constructor of instances of the Trait class given the focal 
    specie and the parameters to define infinitesimal or quantitative fitness.
}
\details{
Infinitesimal traits need the mean, the additive and the dominant 
    effect and optionally the vector of the putative genes. Quantitative 
    traits are defined given the mean and a data frame with the putative 
    genes and their additive and dominant effects.
}
\examples{
data(ToyMap)
spc <- set_specie(ToyMap)
AA <- founder(spc, "AA")
aa <- spc$founder("aa")

F1  <- cross(n = 1, AA, aa) # the hybrid

## set a infinitesimal & a quantitative fitness
infty <- set_infty(spc, m = 0, a = 1, d = .5) # partial dominance
genes <- data.frame(snp = sample(ToyMap$snp, 10), add = rnorm(10), dom = rnorm(10))
quant <- set_quant(spc, m = 0, data = genes)

## evaluating the breeding value 
infty$alpha(AA)
quant$alpha(F1)

}
