% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isoforest.R
\name{isotree.build.indexer}
\alias{isotree.build.indexer}
\title{Build Indexer for Faster Terminal Node Predictions and/or Distance Calculations}
\usage{
isotree.build.indexer(model, with_distances = FALSE, nthreads = model$nthreads)
}
\arguments{
\item{model}{An Isolation Forest model (as returned by function \link{isolation.forest})
for which an indexer for terminal node numbers and/or distances will be added.

\bold{The object will be modified in-place}.}

\item{with_distances}{Whether to also pre-calculate node distances in order to speed up
`predict` with `type="dist"` or `type="avg_sep"`.
Note that this will consume a lot more memory and make the resulting object significantly
heavier.}

\item{nthreads}{Number of parallel threads to use.}
}
\value{
The same `model` object (as invisible), but now with an indexer added to it. Note
the input object is modified in-place regardless.
}
\description{
Builds an index of terminal nodes for faster prediction of terminal node numbers
(calling `predict` with `type="tree_num"`).

Optionally, can also pre-calculate terminal node distances in order to speed up
distance calculations (calling `predict` with `type="dist"` or `type="avg_sep"`).
}
\details{
This feature is not available for models that use `missing_action="divide"`
or `new_categ_action="weighted"` (which are the defaults when passing `ndim=1`).
}
\seealso{
\link{isotree.drop.indexer}
}
