% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ui_model-building.R
\name{set_prop_family}
\alias{set_prop_family}
\title{Set the distribution family for observed proportions}
\usage{
set_prop_family(nm, family, quiet = FALSE)
}
\arguments{
\item{nm}{A \code{networkModel} object (output from
\code{\link{new_networkModel}}).}

\item{family}{Allowed values are "gamma_cv", "beta_phi", "normal_cv", and
"normal_sd".}

\item{quiet}{Boolean, if \code{FALSE} print a message indicating which
distribution family is used for proportions.}
}
\value{
A \code{networkModel} object.
}
\description{
Set the distribution family for observed proportions
}
\examples{
library(magrittr)

m <- new_networkModel() \%>\%
  set_topo(links = "NH4, NO3 -> epi -> pseph, tricor")
m <- m \%>\% set_prop_family("beta_phi")
m
attr(m, "prop_family")

}
