% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ui_others.R
\name{dic}
\alias{dic}
\title{Calculate DIC from a model output}
\usage{
dic(..., weight = TRUE)
}
\arguments{
\item{...}{One or several \code{mcmc.list} objects, output(s) from
\code{\link{run_mcmc}}.}

\item{weight}{Boolean, if TRUE calculate DIC weights based on Link and
Barker 2010 (Link, W. A., and R. J. Barker. 2010. Bayesian Inference
With Ecological Applications. Amsterdam Boston Heidelberg London:
Elsevier/Academic Press).}
}
\value{
A tibble with one row per \code{mcmc.list} object provided in
    \code{...}. This tibble is sorted by DIC, so the row order might be
    different from the \code{mcmc.list} objects order.
}
\description{
Note that DIC might not be indicated for network models, as the posteriors
are often not multinormal distributions.
}
\details{
LOO is probably not a good choice either since the data is akin to a time
series (so data points are not independent). Maybe WAIC could be an option?
(TODO: read about this.)

DIC is calculated as:

DIC = Dbar + pD

where D are deviance values calculated as -2 * loglik for each MCMC
iteration, Dbar is the mean deviance value and pD is the effective number of
parameters in the model and can be calculated as var(D)/2 (Gelman 2003).
}
\examples{
\donttest{
# Define two different models
m1 <- aquarium_mod
m2 <- set_topo(m1, c("NH4 -> algae -> daphnia -> NH4", "algae -> NH4"))
m2 <- set_priors(m2, priors(m1))
m2 <- set_priors(m2, normal_p(0, 0.5), "upsilon_algae_to_NH4")
# Run the models
r1 <- run_mcmc(m1, chains = 2)
r2 <- run_mcmc(m2, chains = 2)
# Model comparison with DIC
dic(r1, r2)
}

}
