% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ui_model-building.R
\name{set_half_life}
\alias{set_half_life}
\title{Set the half-life for radioactive tracers}
\usage{
set_half_life(nm, hl, quiet = FALSE)
}
\arguments{
\item{nm}{A \code{networkModel} object.}

\item{hl}{Half-life value, in the same time unit as the observations are (or
will be) given. Setting half-life to zero is equivalent to using a
stable isotope (no decay used in the model).}

\item{quiet}{Boolean for verbosity.}
}
\value{
A \code{networkModel} object.
}
\description{
Indicating a non-zero value for half-life will add a decay to the marked
portion of the tracer element. The decay constant is calculated from the
half-life value as:
}
\details{
lambda_decay = log(2) / half_life

Note that for correct calculations the half-life value should be given in
the same time unit (e.g. hour, day) that the time unit used for
observations.
}
\examples{
library(magrittr)
x <- new_networkModel() \%>\%
    set_topo("32P -> root -> leaf") \%>\%
    set_half_life(hl = 14.268)
x

}
