% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/ternary_contour.R
\docType{methods}
\name{ternary_contour}
\alias{ternary_contour}
\alias{ternary_contour-method}
\alias{ternary_contour,numeric,numeric,numeric-method}
\alias{ternary_contour,ANY,missing,missing-method}
\title{Contour Lines}
\usage{
ternary_contour(x, y, z, ...)

\S4method{ternary_contour}{numeric,numeric,numeric}(
  x,
  y,
  z,
  value,
  n = 50,
  nlevels = 10,
  levels = pretty(range(value, na.rm = TRUE), nlevels),
  ilr = TRUE,
  method = "linear",
  extrapolate = FALSE,
  palette = function(i) grDevices::hcl.colors(i, "YlOrRd", rev = TRUE),
  ...
)

\S4method{ternary_contour}{ANY,missing,missing}(
  x,
  value,
  n = 50,
  nlevels = 10,
  levels = pretty(range(value, na.rm = TRUE), nlevels),
  ilr = TRUE,
  method = "linear",
  extrapolate = FALSE,
  palette = function(i) grDevices::hcl.colors(i, "YlOrRd", rev = TRUE),
  ...
)
}
\arguments{
\item{x, y, z}{A \code{\link{numeric}} vector giving the x, y and z ternary coordinates
of a set of points. If \code{y} and \code{z} are missing, an attempt is made to
interpret \code{x} in a suitable way (see \code{\link[grDevices:xyz.coords]{grDevices::xyz.coords()}}).}

\item{...}{Further arguments to be passed to \code{\link[=ternary_lines]{ternary_lines()}}.}

\item{value}{A \code{\link{numeric}} vector giving the values to be plotted.}

\item{n}{A length-one \code{\link{numeric}} specifying the number of grid points.}

\item{nlevels}{A length-one \code{\link{numeric}} vector specifying the number of
contour levels desired. Only used if \code{levels} is \code{NULL}.}

\item{levels}{A \code{\link{numeric}} vector of levels at which to draw contour lines.}

\item{ilr}{A \code{\link{logical}} scalar: should interpolation be computed in ILR
space? If \code{FALSE}, interpolation is computed in Cartesian space.}

\item{method}{A \code{\link{character}} string: specifying the method for interpolation
(see \code{\link[interp:interp]{interp::interp()}}).}

\item{extrapolate}{A \code{\link{logical}} scalar: should extrapolation be used outside
of the convex hull determined by the data points (see \code{\link[interp:interp]{interp::interp()}})?}

\item{palette}{A color palette \code{\link{function}} that takes a single integer
argument (the number of levels) and returns a vector of colors.}
}
\value{
\code{ternary_contour()} is called it for its side-effects.

Invisibly returns a \code{\link{list}} with elements \code{levels} (the contour levels) and
\code{colors} (the contour colors) that can be used for a legend.
}
\description{
Computes and draws contour lines.
}
\details{
Contour are computed from a bivariate interpolation onto a grid,
after an isometric log ratio transformation of the original data.
}
\note{
The \pkg{interp} package needs to be installed on your machine.
}
\examples{
## Add density
## Data from Aitchison 1986
ternary_plot(arctic, panel.first = ternary_grid())
levels <- ternary_contour(arctic, value = arctic$depth, n = 100, nlevels = 10)

## Add a legend
legend_image <- grDevices::as.raster(rev(levels$colors))
graphics::rasterImage(legend_image, 0.85, 0.75, 0.9, 1)
graphics::text(x = 0.9, y = c(0.75, 1), labels = range(levels$levels), pos = 4)
}
\seealso{
\code{\link[interp:interp]{interp::interp()}}, \code{\link[grDevices:contourLines]{grDevices::contourLines()}}

Other statistics: 
\code{\link{ternary_density}()},
\code{\link{ternary_ellipse}()},
\code{\link{ternary_hull}()},
\code{\link{ternary_mean}()},
\code{\link{ternary_pca}()}
}
\author{
N. Frerebeau
}
\concept{statistics}
