% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iso8601standardise.R
\name{iso8601standardise}
\alias{iso8601standardise}
\title{Standardise ISO8601 strings}
\usage{
iso8601standardise(x, fillmissing = TRUE, toymd = TRUE, tozulu = TRUE)
}
\arguments{
\item{x}{a character vector with valid ISO8601 date. time, or date-time
strings.}

\item{fillmissing}{recplace missing parts ot dates, and times with the
minimum possible values. In dates this is 1, in times this is 0.}

\item{toymd}{convert dates in year-week-weekday format, or year-day format to
year-month-day format.}

\item{tozulu}{convert times to GMT. Note that this implies \code{fillmissing
= TRUE} for date-time strings with time zone.}
}
\value{
Returns a character vector with the same length as \code{x} with the
ISO8601 strings in a standardised format. For input strings that are not a
valid ISO8601 time, date or date-time string \code{NA} is returned and a
warning is issued.
}
\description{
Standardise ISO8601 strings
}
\examples{
''
x <- c("2024-01-01T12:34", "2024W011", "2024-123T13:00:00+01", "T1530", NA)

iso8601standardise(x)
iso8601standardise(x, fillmissing = FALSE)
iso8601standardise(x, toymd = FALSE)
iso8601standardise(x, tozulu = FALSE)

}
