% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/processAssay.R
\name{getAssayTabs}
\alias{getAssayTabs}
\title{Retrieve Assay Tables from an ISA object.}
\usage{
getAssayTabs(isaObject)
}
\arguments{
\item{isaObject}{An object of the \code{\link{ISA-class}}.}
}
\value{
A list of lists of objects of class \code{\link{assayTab}}, where
each list element, named by the Study Identifier, contains a list of
objects of class \code{\link{assayTab}}.
}
\description{
Retrieve from an object of the \code{\link{ISA-class}} the Assay Tables.
}
\examples{
## Read example Atwell data set.
isaObject1 <- readISATab(path = file.path(system.file("extdata/Atwell",
                                          package = "isatabr")))

## Get assay tabs for isaObject1.
aTabObjects <- getAssayTabs(isaObject1)

}
