% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen_weight.R
\name{gen.weight}
\alias{gen.weight}
\title{Generate Weights}
\usage{
gen.weight(n = 41, dist = "norm", mu = 0, sigma = 1, l = -4, u = 4, theta)
}
\arguments{
\item{n}{An integer identifying the number of theta (or node) values for which weights are generated. Default is 41.}

\item{dist}{A character string specifying a probability distribution from which the weights are generated. Available distributions are
"norm" for a normal distribution, "unif" for a uniform distribution, and "emp" for an empirical distribution.
When \code{dist = "norm"}, either \code{n} or \code{theta} can be specified, when \code{dist = "unif"},
only \code{n} can be used, and when \code{dist = "emp"}, only \code{theta} can be used.}

\item{mu, sigma}{A mean and standard deviation of a normal distribution.}

\item{l, u}{Lower and upper limits of a uniform distribution.}

\item{theta}{A vector of empirical theta (or node) values for which weights are generated.}
}
\value{
This function returns a data frame with two columns, where the first column has theta values (nodes) and the second column provides weights.
}
\description{
This function generates a set of weights based on a set of theta values to be used in the functions \code{\link{est_score}}
and \code{\link{sx2_fit}}.
}
\details{
When the argument \code{theta} is missing, \emph{n} weights can be generated from either the normal distribution or the uniform distribution.
Note that if \code{dist = "norm"}, gaussian quadrature points and weights from the normal distribution are generated. See
\code{gauss.quad.prob()} in the \pkg{statmod} package for more details.

When the argument \code{theta} is not missing, the weights corresponding to the provided theta values are generated. Specifically, if
\code{dist = "norm"}, normalized weights from the normal distribution are returned. If \code{dist = "emp"}, every specified theta value has the equal
values of normalized weights.
}
\examples{
## example 1
## generate 41 gaussian quadrature points and weights of normal distribution
gen.weight(n = 41, dist = "norm", mu = 0, sigma = 1)

## example 2
## generate 41 theta values and weights from the uniform normal distribution,
## given the mininum value of -4 and the maximum value of 4
gen.weight(n = 41, dist = "unif", l = -4, u = 4)

## example 3
## generate the normalized weights from the standardized normal distribution,
## given a set of theta values
theta <- seq(-4, 4, by = 0.1)
gen.weight(dist = "norm", mu = 0, sigma = 1, theta = theta)

## example 4
## generate the same values of normalized weights for the theta values that are
## randomly sampled from the standardized normal distribution
theta <- rnorm(100)
gen.weight(dist = "emp", theta = theta)

}
\seealso{
\code{\link{est_score}}, \code{\link{sx2_fit}}
}
\author{
Hwanggyu Lim \email{hglim83@gmail.com}
}
