% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_item.R
\name{plot.Item}
\alias{plot.Item}
\title{Plot Item Characteristic Curve of an \code{Item} object}
\usage{
\method{plot}{Item}(
  x,
  theta_range = c(-4, 4),
  title = "",
  suppress_plot = FALSE,
  category_names = FALSE,
  legend_title = NULL,
  base_r_graph = FALSE,
  ...
)
}
\arguments{
\item{x}{An \code{\link{Item-class}} object.}

\item{theta_range}{Either (a) a numeric vector of length two where the values
are minimum and maximum theta values, or, (b) a numeric vector of length
more than two where values represents the theta values that will be
plotted.}

\item{title}{Title of the plot. By default if the item is 1-4PM IRT model
then the title will be "Item Characteristic Curve" if the item
follows Graded Response Model the title will be
"Category Response Functions". Set it to \code{NULL} to suppress the
title.}

\item{suppress_plot}{If \code{FALSE} the function will print the plot. If
\code{TRUE}, function will return the plot object. Default value is
\code{FALSE}. Function cannot suppress plot when
\code{base_r_graph = TRUE}, but graph still can be saved in a
variable.}

\item{category_names}{If the model used is 'GRM' (Graded Response Model)
these names will serve as category names. For example,
c("Strongly Disagree", "Disagree", "Agree", "Strongly Agree").
The default is \code{FALSE} where the default category scores
will be printed. If the value is \code{NULL} no legend will be
printed but the categories will be printed differently.}

\item{legend_title}{The title of the plot's legend.}

\item{base_r_graph}{If \code{TRUE} function will plot graphs using base R
graphics. If \code{FALSE} the function will check whether 'ggplot2' package
is installed. If it is installed, it will use 'ggplot2' package for the
plot. The default value is \code{FALSE}.}

\item{...}{Additional arguments that will be passed to \code{geom_line}}
}
\value{
Depending on the value of \code{suppress_plot} function either prints
the item characteristic curve or returns the plot object.
}
\description{
\code{plot.Item} Plots the item characteristic curve for dichotomous items
and category response functions for polytomous items.
}
\examples{
plot(x = item(b = 0.3, D = 1, model = "1PL"))

itm1 <- item(a = 1.2, b = 0.3, c = .2, model = "3PL")
plot(itm1)
plot(item(a = 1.2, b = 0.3, c = .2, d = .89, D = 1))

# Use base R graphics for the plot
plot(itm1, base_r_graph = TRUE)

# Plot Graded Response Model
itm2 <- item(a = 0.902, b = c(-1.411, 0.385, 1.79), model = "GRM")
plot(itm2)
plot(itm2, category_names = c("Strongly Disagree", "Disagree", "Agree",
                              "Strongly Agree"))

plot(itm2, category_names = c("Strongly Disagree", "Disagree", "Agree",
                              "Strongly Agree"), base_r_graph = TRUE)

# A Graded Response Model item with two categories (i.e. 2PL item):
itm3 <- item(a = 0.8, b = 1, model = "GRM")
plot(itm3, category_names = c("Incorrect", "Correct"),
     legend_title = "Response")

\dontrun{
# Change the y-axis label (Only available if 'ggplot2' is installed)
# plot(itm3, suppress_plot = TRUE) + ylab("New Label")
}

}
\author{
Emre Gonulates
}
