% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/itempool-class-methods.R
\name{$,Itempool-method}
\alias{$,Itempool-method}
\title{Get slots of the an \code{\link{Itempool-class}} object.}
\usage{
\S4method{$}{Itempool}(x, name)
}
\arguments{
\item{x}{An \code{\link{Itempool-class}} object.}

\item{name}{Name of the parameter.
Available values:
\describe{
  \item{\strong{\code{'id'}}}{Extract \code{id}'s of all items
    and testlets.
    This will not extract the \code{item_id}'s of items within the
    testlet.}
  \item{\strong{\code{'content'}}}{Extract \code{content}'s of
    all items and testlets.
    This will not extract the \code{content}'s of items within the
    testlet.}
  \item{\strong{\code{'model'}}}{Extract \code{model}'s of
    all items and testlets.
    This will not extract the \code{model}'s of items within the
    testlet. Use \code{$item_model} to extract models of standalone
    items.}
  \item{\strong{\code{'misc'}}}{Extract \code{misc} parameters of
    all items and testlets.
    This will not extract the \code{misc} parameters of items
    within the testlet.}
  \item{\strong{\code{'item_list'}}}{Extract individual elements of
    item pool. If there are testlets in the item pool, a testlet
    will be an item of the resulting list. If individual items
    within the testlet is desired to be elements of the list, then
    use \code{$items}.}
  \item{\strong{\code{'items'}}}{Extract individual items
    within the item pool. If there are testlets in the item pool
    individual elements of the testlet will be extracted. Resulting
    list will only consist of \code{\link{Item-class}} objects.
  }
  \item{\strong{\code{'parameters'}}}{Extract \code{parameters}'s of
    all items and testlets.
    This will not extract the \code{parameters}'s of items within
    the testlet.}
  \item{\strong{\code{'se'}}}{Extract
    \code{se}'s of all items and testlets.
    This will not extract the \code{se}'s of items
    within the testlet.}
  \item{\strong{\code{'n'}}}{Return a list with three objects:
    \code{elements} the number of standalone items and testlets.
    \code{testlets} the number of Testlet objects.
    \code{items} the sum of the number of items within testlets and
    standalone items.
    }
  \item{\strong{\code{'max_score'}}}{Returns the maximum possible
    raw score of the item pool.
    }
  \item{\strong{\code{'item_id'} or \code{'resp_id'}}}{Extract
    \code{item_id}'s of all standalone items and items within the
    testlets. It will not return \code{testlet_id}'s. This is
    mainly to get the \code{item_id}'s of items which has a
    response.
    }
  \item{\strong{\code{'testlet_id'}}}{Extract \code{testlet_id}'s
    of all items within the testlets. If the item is a standalone
    item, then a \code{NA} vector will be returned for it's testlet
    ID value.
    }
  \item{\strong{\code{'item_content'}}}{Extract
    \code{content}'s of all standalone items and items within the
    testlets. It will not return testlet \code{content}'s. This
    is mainly to get the \code{content}'s of items which has a
    response.
    }
  \item{\strong{\code{'item_model'}}}{Extract
    \code{model}'s of all standalone items and items within the
    testlets. It will not return testlet \code{model}'s. This is
    mainly to get the \code{model}'s of items which has a response.
    }
  \item{\strong{\code{'item_misc'}}}{Extract
    \code{misc} fields of all standalone items and items within
    the testlets. It will not return testlet \code{misc} fields.
    }
  \item{\strong{\code{'resp_item_list'}}}{Combine items that are
    not in a testlet and items within a testlet and return a list
    object. This list does not contain any \code{Testlet} objects.
    All of the elements are \code{Item} objects. If there are no
    testlets in the item pool, then this argument will be the
    same as \code{$item_list}.
    }
  \item{\strong{\code{'item_max_score'}}}{Extract the maximum score
    each standalone item can get.
    }
}}
}
\value{
See the 'name' argument above for possible return values.
}
\description{
Get slots of the an \code{\link{Itempool-class}} object.
}
\examples{
ip <- generate_ip(n = 7, model = "3PL", content = c("Geometry", "Algebra"))

ip$a
ip$b
ip$D
ip$model
ip$id
ip$content

}
\author{
Emre Gonulates
}
