% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_info.R
\name{plot_info}
\alias{plot_info}
\title{Plot Item Information Function}
\usage{
plot_info(
  ip,
  tif = FALSE,
  theta_range = c(-5, 5),
  focus_item = NULL,
  title = "",
  suppress_plot = FALSE,
  base_r_graph = FALSE,
  ...
)
}
\arguments{
\item{ip}{An \code{\link{Item-class}} or \code{\link{Itempool-class}}
object.}

\item{tif}{If \code{TRUE} a test information plot will be plotted. The
default value is \code{FALSE}.}

\item{theta_range}{Either (a) a numeric vector of length two where the values
are minimum and maximum theta values, or, (b) a numeric vector of length
more than two where values represents the theta values that will be
plotted.}

\item{focus_item}{If one or more items information graphs needed to be
focused whereas rest of the items' information functions needed to be on
the background, provide item numbers or item ID's to be focused.}

\item{title}{Title of the plot}

\item{suppress_plot}{If \code{FALSE} the function will print the plot. If
\code{TRUE}, function will return the plot object. Default value is
\code{FALSE}.}

\item{base_r_graph}{If \code{TRUE} function will plot graphs using base R
graphics. If \code{FALSE} the function will check whether 'ggplot2' package
is installed. If it is installed, it will use 'ggplot2' package for the
plot. The default value is \code{FALSE}.}

\item{...}{Extra parameters that will pass to \code{geom_line}.}
}
\value{
Depending on the value of \code{suppress_plot} function either prints
the item information function or returns the plot object.
}
\description{
\code{plot_info} Plots the item information function.
}
\examples{
# Plot the information function of an item
plot_info(item(b = 1))

# Plot information function(s) of an Itempool object
n <- sample(10:20,1)
ip <- generate_ip()
plot_info(ip)
plot_info(ip, tif = TRUE)
plot_info(ip, tif = TRUE, theta_range = c(-3, 3))
# Focus on one item
plot_info(ip, focus_item = "Item_2")

# Base R Graphics
plot_info(ip, base_r_graph = TRUE)
plot_info(ip, focus_item = "Item_2", base_r_graph = TRUE)

# Plot information with focus on a specific item(s)
plot_info(ip, focus_item = "Item_1")
plot_info(ip, focus_item = 3)
# plot_info(ip, focus_item = c(2, 8))
# plot_info(ip, focus_item = c("Item_5", "Item_6"))

plot_info(ip, focus_item = 7, alpha = .7, color = "gray")

plot_info(ip, focus_item = "Item_3", color = "green", base_r_graph = TRUE)

}
\author{
Emre Gonulates
}
