% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_icc.R
\name{plot_empirical_icc}
\alias{plot_empirical_icc}
\title{Plot Empirical Item characteristic curve}
\usage{
plot_empirical_icc(
  resp,
  item,
  ip,
  theta = NULL,
  bins = 10,
  binwidth = NULL,
  title = "",
  suppress_plot = FALSE,
  base_r_graph = FALSE,
  ...
)
}
\arguments{
\item{resp}{Response matrix.}

\item{item}{The column number, column name or the 'ID' of the  the item that
should be plotted.}

\item{ip}{An \code{\link{Itempool-class}} object that is needed for some
plots.}

\item{theta}{A vector of examinee abilities.}

\item{bins}{An integer larger than 2 representing of ability groups examinees
should be grouped into. The default is \code{10}. The maximum value of
\code{bins +  1} is the number of possible total scores.}

\item{binwidth}{This determines  the width of each bin of the theta scale.
Within each bin, there might be different number of examinees.}

\item{title}{Title of the plot}

\item{suppress_plot}{If \code{FALSE} the function will print the plot. If
\code{TRUE}, function will return the plot object. Default value is
\code{FALSE}.}

\item{base_r_graph}{If \code{TRUE} function will plot graphs using base R
graphics. If \code{FALSE} the function will check whether 'ggplot2' package
is installed. If it is installed, it will use 'ggplot2' package for the
plot. The default value is \code{FALSE}.}

\item{...}{Extra parameters that will pass to \code{geom_line}.}
}
\value{
Depending on the value of \code{suppress_plot} function either prints
the empirical item characteristic curve or returns the plot object.
}
\description{
\code{plot_emprical_icc} plots empirical item characteristic curve.
It plots observed p-values vs. expected p-values grouped into bins based
theta scores (or any score supplied). Optionally, provide \code{theta}
vector, otherwise examinee abilities will be estimated by
\code{est_ability(..., type = "eap")}. This will slow down the plotting
function.
}
\examples{
ip <- generate_ip(model = c("3PL", "GRM"), n = 20)
true_theta <- rnorm(2000)
resp <- generate_resp_set(ip = ip, theta = true_theta)

plot_empirical_icc(resp, "Item_3", ip = ip, theta = true_theta)
plot_empirical_icc(resp, 3, ip = ip, theta = true_theta)
# Change the number of bins
plot_empirical_icc(resp, 3, ip = ip, theta = true_theta, bins = 10)
# Fixed bin width
plot_empirical_icc(resp, 3, ip = ip, theta = true_theta, binwidth = .2)

# Plot GRM item's ICC
plot_empirical_icc(resp, "Item_4", ip = ip, theta = true_theta)
plot_empirical_icc(resp, "Item_4", ip = ip, theta = true_theta, binwidth = .2)

}
\author{
Emre Gonulates
}
