% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mean.R
\name{mean,Testlet-method}
\alias{mean,Testlet-method}
\title{Calculate the expected value of an Testlet}
\usage{
\S4method{mean}{Testlet}(x, ...)
}
\arguments{
\item{x}{A \code{\link{Testlet-class}} object containing the item
parameters.}

\item{...}{Additional parameters. Specifically \code{theta} argument is
required. \code{theta} should be a numeric vector of ability parameters.}
}
\value{
Item expected values at given theta values will be returned.
}
\description{
\code{mean} Returns the expected values of each item in an
  \code{\link{Testlet-class}} object for a given ability or abilities,
  i.e. \eqn{\theta}.
}
\examples{
t1 <- generate_testlet()
mean(t1, theta = -1.1)
mean(t1, -1.1)

}
\author{
Emre Gonulates
}
