% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/item_analysis.R
\name{item_analysis}
\alias{item_analysis}
\title{Item Analysis Function}
\usage{
item_analysis(resp, criterion = NULL, suppress_output = FALSE)
}
\arguments{
\item{resp}{A \code{matrix} or \code{data.frame} containing the item
responses.}

\item{criterion}{Provide a continuous criterion variable such as a total
raw score, or theta score that will be used in the calculation of
correlation calculations. If this value is \code{NULL}, the total score
will be used.}

\item{suppress_output}{If \code{TRUE}, the function will suppress
console output. Default value is \code{FALSE}}
}
\value{
A list of
  \describe{
    \item{'id'}{Item ID.}
    \item{'n'}{Number of examinees responded this item.}
    \item{'pval'}{p-value, proportion of examinees correctly answered items.}
    \item{'pbis'}{Point biserial correlation.}
    \item{'bis'}{Biserial correlation.}
    \item{'pbis_adj'}{Point biserial correlation between item and total score
      without this item.}
    \item{'bis_adj'}{Biserial correlation between item and total score
      without this item.}
  }
}
\description{
Item Analysis Function
}
\examples{
theta <- rnorm(100)
ip <- generate_ip(n = 20)
resp <- sim_resp(ip = ip, theta = theta, prop_missing = .2)
# Item analysis based on total scores
item_analysis(resp)
# Item analysis based on theta scores
item_analysis(resp, criterion = theta)

}
\author{
Emre Gonulates
}
