% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampling_pie.R
\name{sampling_pie}
\alias{sampling_pie}
\title{Sampling pie plot}
\usage{
sampling_pie(irace_results, param_names = NULL, n_bins = 3, filename = NULL)
}
\arguments{
\item{irace_results}{The data generated when loading the \code{.Rdata} file created by \code{irace} (or the filename of that file).}

\item{param_names}{String vector, A set of parameters to be included (example: param_names = c("algorithm","dlb"))}

\item{n_bins}{Numeric (default 3), number of intervals to generate for numerical parameters.}

\item{filename}{(\code{character(1)}) File name to save the plot, for example \code{"~/path/example/filename.png"}.}
}
\value{
Sampling pie plot
}
\description{
This function creates a pie plot of the values sampled of a set of selected
parameters. Numerical parameters are discretized to maximum \code{n_bins}
intervals. The size of the slices are proportional to the number of
configurations that have assigned a parameter value within the rank or the
value assigned to that slice. Parameters can be selected by providing their
names in the \code{param_names} argument.
}
\examples{
iraceResults <- read_logfile(system.file(package="irace", "exdata",
                                         "irace-acotsp.Rdata", mustWork = TRUE))
sampling_pie(iraceResults)
\donttest{
sampling_pie(iraceResults, param_names = c("algorithm", "dlb", "ants"))
}
}
