% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_experiments_matrix.R
\name{plot_experiments_matrix}
\alias{plot_experiments_matrix}
\title{Heat Map Plot}
\usage{
plot_experiments_matrix(
  irace_results,
  filename = NULL,
  metric = c("raw", "rpd", "rank"),
  show_conf_ids = FALSE,
  interactive = base::interactive()
)
}
\arguments{
\item{irace_results}{The data generated when loading the \code{.Rdata} file created by \code{irace} (or the filename of that file).}

\item{filename}{(\code{character(1)}) File name to save the plot, for example \code{"~/path/example/filename.png"}.}

\item{metric}{Cost metric shown in the plot: \code{"raw"} shows the raw
values, \code{"rpd"} shows relative percentage deviation per instance and
\code{"rank"} shows rank per instance.}

\item{show_conf_ids}{If \code{TRUE}, it shows the configuration IDs in the x-axis. Usually there are too many configurations, thus the default is \code{FALSE}.}

\item{interactive}{(\code{logical(1)}) TRUE if the report may use interactive features (using \code{\link[plotly:ggplotly]{plotly::ggplotly()}}, \code{\link[plotly:plot_ly]{plotly::plot_ly()}} and \code{\link[DT:dataTableOutput]{DT::renderDataTable()}}) or FALSE if such features must be disabled. Defaults to the value returned by \code{interactive()},}
}
\value{
\code{\link[ggplot2:ggplot]{ggplot2::ggplot()}} object
}
\description{
Creates a heatmap plot that shows all performance data seen by irace.
Configurations are shown in the x-axis in the order in which they are
created in the configuration process. Instances are shown in the y-axis in
the order in which they where seen during the configuration run. This plot
gives a general idea of the configuration process progression, the number of
evaluations of each configuration show how long they survived in the
iterated racing procedure.
}
\examples{
iraceResults <- read_logfile(system.file(package="irace", "exdata",
                                         "irace-acotsp.Rdata", mustWork = TRUE))
plot_experiments_matrix(iraceResults)
}
