% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scenario.R
\name{defaultScenario}
\alias{defaultScenario}
\title{Default scenario settings}
\usage{
defaultScenario(scenario = list(), params_def = .irace.params.def)
}
\arguments{
\item{scenario}{\code{list()}\cr Data structure containing \pkg{irace}
settings. The data structure has to be the one returned by the function
\code{\link[=defaultScenario]{defaultScenario()}} or \code{\link[=readScenario]{readScenario()}}.}

\item{params_def}{\code{data.frame()}\cr Definition of the options accepted by
the scenario. This should only be modified by packages that wish to extend
\pkg{irace}.}
}
\value{
A list indexed by the \pkg{irace} parameter names,
containing the default values for each parameter, except for those
already present in the scenario passed as argument.
The scenario list contains the following elements:
\itemize{
\item General options:
\describe{
\item{\code{scenarioFile}}{Path of the file that describes the configuration scenario setup and other irace settings. (Default: \code{"./scenario.txt"})}
\item{\code{execDir}}{Directory where the programs will be run. (Default: \code{"./"})}
\item{\code{logFile}}{File to save tuning results as an R dataset, either absolute path or relative to execDir. (Default: \code{"./irace.Rdata"})}
\item{\code{quiet}}{Reduce the output generated by irace to a minimum. (Default: \code{0})}
\item{\code{debugLevel}}{Debug level of the output of \code{irace}. Set this to 0 to silence all debug messages. Higher values provide more verbose debug messages. (Default: \code{0})}
\item{\code{seed}}{Seed of the random number generator (by default, generate a random seed). (Default: \code{NA})}
\item{\code{repairConfiguration}}{User-defined R function that takes a configuration generated by irace and repairs it. (Default: \code{""})}
\item{\code{postselection}}{Perform a postselection race after the execution of irace to consume all remaining budget. Value 0 disables the postselection race. (Default: \code{1})}
\item{\code{aclib}}{Enable/disable AClib mode. This option enables compatibility with GenericWrapper4AC as targetRunner script. (Default: \code{0})}
}
\item Elitist \code{irace}:
\describe{
\item{\code{elitist}}{Enable/disable elitist irace. (Default: \code{1})}
\item{\code{elitistNewInstances}}{Number of instances added to the execution list before previous instances in elitist irace. (Default: \code{1})}
\item{\code{elitistLimit}}{In elitist irace, maximum number per race of elimination tests that do not eliminate a configuration. Use 0 for no limit. (Default: \code{2})}
}
\item Internal \code{irace} options:
\describe{
\item{\code{sampleInstances}}{Randomly sample the training instances or use them in the order given. (Default: \code{1})}
\item{\code{softRestart}}{Enable/disable the soft restart strategy that avoids premature convergence of the probabilistic model. (Default: \code{1})}
\item{\code{softRestartThreshold}}{Soft restart threshold value for numerical parameters. (Default: \code{1e-04})}
\item{\code{nbIterations}}{Maximum number of iterations. (Default: \code{0})}
\item{\code{nbExperimentsPerIteration}}{Number of runs of the target algorithm per iteration. (Default: \code{0})}
\item{\code{minNbSurvival}}{Minimum number of configurations needed to continue the execution of each race (iteration). (Default: \code{0})}
\item{\code{nbConfigurations}}{Number of configurations to be sampled and evaluated at each iteration. (Default: \code{0})}
\item{\code{mu}}{Parameter used to define the number of configurations sampled and evaluated at each iteration. (Default: \code{5})}
}
\item Target algorithm parameters:
\describe{
\item{\code{parameterFile}}{File that contains the description of the parameters of the target algorithm. (Default: \code{"./parameters.txt"})}
\item{\code{parameters}}{Parameters space object (usually read from a file using \code{readParameters}). (Default: \code{""})}
}
\item Target algorithm execution:
\describe{
\item{\code{targetRunner}}{Executable called for each configuration that executes the target algorithm to be tuned. See the templates and examples provided. (Default: \code{"./target-runner"})}
\item{\code{targetRunnerLauncher}}{Executable that will be used to launch the target runner, when \code{targetRunner} cannot be executed directly (e.g., a Python script in Windows). (Default: \code{""})}
\item{\code{targetCmdline}}{Command-line arguments provided to \code{targetRunner} (or \code{targetRunnerLauncher} if defined). The substrings \code{\{configurationID\}}, \code{\{instanceID\}},  \code{\{seed\}},  \code{\{instance\}}, and \code{\{bound\}} will be replaced by their corresponding values. The substring \code{\{targetRunnerArgs\}} will be replaced by the concatenation of the switch and value of all active parameters of the particular configuration being evaluated.  The substring \code{\{targetRunner\}}, if present, will be replaced by the value of \code{targetRunner} (useful when using \code{targetRunnerLauncher}). (Default: \code{"{configurationID} {instanceID} {seed} {instance} {bound} {targetRunnerArgs}"})}
\item{\code{targetRunnerRetries}}{Number of times to retry a call to \code{targetRunner} if the call failed. (Default: \code{0})}
\item{\code{targetRunnerTimeout}}{Timeout in seconds of any \code{targetRunner} call (only applies to \code{target-runner} executables not to R functions), ignored if 0. (Default: \code{0})}
\item{\code{targetRunnerData}}{Optional data passed to \code{targetRunner}. This is ignored by the default \code{targetRunner} function, but it may be used by custom \code{targetRunner} functions to pass persistent data around. (Default: \code{""})}
\item{\code{targetRunnerParallel}}{Optional R function to provide custom parallelization of \code{targetRunner}. (Default: \code{""})}
\item{\code{targetEvaluator}}{Optional script or R function that provides a numeric value for each configuration. See templates/target-evaluator.tmpl (Default: \code{""})}
\item{\code{deterministic}}{If the target algorithm is deterministic, configurations will be evaluated only once per instance. (Default: \code{0})}
\item{\code{parallel}}{Number of calls to \code{targetRunner} to execute in parallel. Values \code{0} or \code{1} mean no parallelization. (Default: \code{0})}
\item{\code{loadBalancing}}{Enable/disable load-balancing when executing experiments in parallel. Load-balancing makes better use of computing resources, but increases communication overhead. If this overhead is large, disabling load-balancing may be faster. (Default: \code{1})}
\item{\code{mpi}}{Enable/disable MPI. Use \code{Rmpi} to execute \code{targetRunner} in parallel (parameter \code{parallel} is the number of slaves). (Default: \code{0})}
\item{\code{batchmode}}{Specify how irace waits for jobs to finish when \code{targetRunner} submits jobs to a batch cluster: sge, pbs, torque, slurm or htcondor. \code{targetRunner} must submit jobs to the cluster using, for example, \code{qsub}. (Default: \code{0})}
}
\item Initial configurations:
\describe{
\item{\code{initConfigurations}}{Data frame describing initial configurations (usually read from a file using \code{readConfigurations}). (Default: \code{""})}
\item{\code{configurationsFile}}{File that contains a table of initial configurations. If empty or \code{NULL}, all initial configurations are randomly generated. (Default: \code{""})}
}
\item Training instances:
\describe{
\item{\code{instances}}{Character vector of the instances to be used in the \code{targetRunner}. (Default: \code{""})}
\item{\code{trainInstancesDir}}{Directory where training instances are located; either absolute path or relative to current directory. If no \code{trainInstancesFiles} is provided, all the files in \code{trainInstancesDir} will be listed as instances. (Default: \code{""})}
\item{\code{trainInstancesFile}}{File that contains a list of training instances and optionally additional parameters for them. If \code{trainInstancesDir} is provided, \code{irace} will search for the files in this folder. (Default: \code{""})}
\item{\code{blockSize}}{Number of training instances, that make up a \verb{block' in \code{trainInstancesFile}. Elimination of configurations will only be performed after evaluating a complete block and never in the middle of a block. Each block typically contains one instance from each instance class (type or family) and the block size is the number of classes. (Default: }1\verb{)\} \} \\item Tuning budget: \\describe\{ \\item\{}maxExperiments\verb{\}\{Maximum number of runs (invocations of \code{targetRunner}) that will be performed. It determines the maximum budget of experiments for the tuning. (Default: }0\verb{)\} \\item\{}minExperiments\verb{\}\{Minimum number of runs (invocations of \code{targetRunner}) that will be performed. It determines the minimum budget of experiments for the tuning. The actual budget depends on the number of parameters and \code{minSurvival}. (Default: }NA\verb{)\} \\item\{}maxTime\verb{\}\{Maximum total execution time for the executions of \code{targetRunner}. \code{targetRunner} must return two values: cost and time. This value and the one returned by \code{targetRunner} must use the same units (seconds, minutes, iterations, evaluations, ...). (Default: }0\verb{)\} \\item\{}budgetEstimation\verb{\}\{Fraction (smaller than 1) of the budget used to estimate the mean computation time of a configuration. Only used when \code{maxTime} > 0 (Default: }0.05\verb{)\} \\item\{}minMeasurableTime\verb{\}\{Minimum time unit that is still (significantly) measureable. (Default: }0.01\verb{)\} \} \\item Statistical test: \\describe\{ \\item\{}testType\verb{\}\{Statistical test used for elimination. The default value selects \code{t-test} if \code{capping} is enabled or \code{F-test}, otherwise. Valid values are: F-test (Friedman test), t-test (pairwise t-tests with no correction), t-test-bonferroni (t-test with Bonferroni's correction for multiple comparisons), t-test-holm (t-test with Holm's correction for multiple comparisons). (Default: }""\verb{)\} \\item\{}firstTest\verb{\}\{Number of instances evaluated before the first elimination test. It must be a multiple of \code{eachTest}. (Default: }5\verb{)\} \\item\{}eachTest\verb{\}\{Number of instances evaluated between elimination tests. (Default: }1\verb{)\} \\item\{}confidence\verb{\}\{Confidence level for the elimination test. (Default: }0.95\verb{)\} \} \\item Adaptive capping: \\describe\{ \\item\{}capping\verb{\}\{Enable the use of adaptive capping, a technique designed for minimizing the computation time of configurations. Capping is enabled by default if \code{elitist} is active, \code{maxTime > 0} and  \code{boundMax > 0}. (Default: }NA\verb{)\} \\item\{}cappingType\verb{\}\{Measure used to obtain the execution bound from the performance of the elite configurations.\\itemize\{\\item median: Median performance of the elite configurations.\\item mean: Mean performance of the elite configurations.\\item best: Best performance of the elite configurations.\\item worst: Worst performance of the elite configurations.\} (Default: }"median"\verb{)\} \\item\{}boundType\verb{\}\{Method to calculate the mean performance of elite configurations.\\itemize\{\\item candidate: Mean execution times across the executed instances and the current one.\\item instance: Execution time of the current instance.\} (Default: }"candidate"\verb{)\} \\item\{}boundMax\verb{\}\{Maximum execution bound for \code{targetRunner}. It must be specified when capping is enabled. (Default: }0\verb{)\} \\item\{}boundDigits\verb{\}\{Precision used for calculating the execution time. It must be specified when capping is enabled. (Default: }0\verb{)\} \\item\{}boundPar\verb{\}\{Penalization constant for timed out executions (executions that reach \code{boundMax} execution time). (Default: }1\verb{)\} \\item\{}boundAsTimeout\verb{\}\{Replace the configuration cost of bounded executions with \code{boundMax}. (Default: }1\verb{)\} \} \\item Recovery: \\describe\{ \\item\{}recoveryFile\verb{\}\{Previously saved log file to recover the execution of \code{irace}, either absolute path or relative to the current directory.  If empty or \code{NULL}, recovery is not performed. (Default: }""\verb{)\} \} \\item Testing: \\describe\{ \\item\{}testInstancesDir\verb{\}\{Directory where testing instances are located, either absolute or relative to current directory. (Default: }""\verb{)\} \\item\{}testInstancesFile\verb{\}\{File containing a list of test instances and optionally additional parameters for them. (Default: }""\verb{)\} \\item\{}testInstances\verb{\}\{Character vector of the instances to be used in the \code{targetRunner} when executing the testing. (Default: }""\verb{)\} \\item\{}testNbElites\verb{\}\{Number of elite configurations returned by irace that will be tested if test instances are provided. (Default: }1\verb{)\} \\item\{}testIterationElites\verb{\}\{Enable/disable testing the elite configurations found at each iteration. (Default: }0`)}
}
}
}
\description{
Return scenario object with default values.
}
\seealso{
\describe{
\item{\code{\link[=readScenario]{readScenario()}}}{for reading a configuration scenario from a file.}
\item{\code{\link[=printScenario]{printScenario()}}}{prints the given scenario.}
\item{\code{\link[=defaultScenario]{defaultScenario()}}}{returns the default scenario settings of \pkg{irace}.}
\item{\code{\link[=checkScenario]{checkScenario()}}}{to check that the scenario is valid.}
}
}
\author{
Manuel López-Ibáñez and Jérémie Dubois-Lacoste
}
